/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.Rule$1;
import org.apache.commons.codec.language.bm.Rule$10;
import org.apache.commons.codec.language.bm.Rule$2;
import org.apache.commons.codec.language.bm.Rule$3;
import org.apache.commons.codec.language.bm.Rule$4;
import org.apache.commons.codec.language.bm.Rule$5;
import org.apache.commons.codec.language.bm.Rule$6;
import org.apache.commons.codec.language.bm.Rule$7;
import org.apache.commons.codec.language.bm.Rule$8;
import org.apache.commons.codec.language.bm.Rule$9;
import org.apache.commons.codec.language.bm.Rule$Phoneme;
import org.apache.commons.codec.language.bm.Rule$PhonemeExpr;
import org.apache.commons.codec.language.bm.Rule$PhonemeList;
import org.apache.commons.codec.language.bm.Rule$RPattern;
import org.apache.commons.codec.language.bm.RuleType;

public class Rule {
    public static final Rule$RPattern ALL_STRINGS_RMATCHER = new Rule$1();
    public static final String ALL = "ALL";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String HASH_INCLUDE = "#include";
    private static final Map<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>> RULES = new EnumMap<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>>(NameType.class);
    private final Rule$RPattern lContext;
    private final String pattern;
    private final Rule$PhonemeExpr phoneme;
    private final Rule$RPattern rContext;

    private static boolean contains(CharSequence charSequence, char c2) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != c2) continue;
            return true;
        }
        return false;
    }

    private static String createResourceName(NameType nameType, RuleType ruleType, String string) {
        return String.format("org/apache/commons/codec/language/bm/%s_%s_%s.txt", nameType.getName(), ruleType.getName(), string);
    }

    private static Scanner createScanner(NameType nameType, RuleType ruleType, String string) {
        String string2 = Rule.createResourceName(nameType, ruleType, string);
        InputStream inputStream = Languages.class.getClassLoader().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to load resource: " + string2);
        }
        return new Scanner(inputStream, "UTF-8");
    }

    private static Scanner createScanner(String string) {
        String string2 = String.format("org/apache/commons/codec/language/bm/%s.txt", string);
        InputStream inputStream = Languages.class.getClassLoader().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to load resource: " + string2);
        }
        return new Scanner(inputStream, "UTF-8");
    }

    private static boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        int n = charSequence.length() - 1;
        for (int i = charSequence2.length() - 1; i >= 0; --i) {
            if (charSequence.charAt(n) != charSequence2.charAt(i)) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static List<Rule> getInstance(NameType nameType, RuleType ruleType, Languages$LanguageSet languages$LanguageSet) {
        Map<String, List<Rule>> map = Rule.getInstanceMap(nameType, ruleType, languages$LanguageSet);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (List<Rule> list : map.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static List<Rule> getInstance(NameType nameType, RuleType ruleType, String string) {
        return Rule.getInstance(nameType, ruleType, Languages$LanguageSet.from(new HashSet<String>(Arrays.asList(string))));
    }

    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType ruleType, Languages$LanguageSet languages$LanguageSet) {
        return languages$LanguageSet.isSingleton() ? Rule.getInstanceMap(nameType, ruleType, languages$LanguageSet.getAny()) : Rule.getInstanceMap(nameType, ruleType, "any");
    }

    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType ruleType, String string) {
        Map<String, List<Rule>> map = RULES.get((Object)nameType).get((Object)ruleType).get(string);
        if (map == null) {
            throw new IllegalArgumentException(String.format("No rules found for %s, %s, %s.", nameType.getName(), ruleType.getName(), string));
        }
        return map;
    }

    private static Rule$Phoneme parsePhoneme(String string) {
        int n = string.indexOf("[");
        if (n >= 0) {
            if (!string.endsWith("]")) {
                throw new IllegalArgumentException("Phoneme expression contains a '[' but does not end in ']'");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length() - 1);
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string3.split("[+]")));
            return new Rule$Phoneme(string2, Languages$LanguageSet.from(hashSet));
        }
        return new Rule$Phoneme(string, Languages.ANY_LANGUAGE);
    }

    private static Rule$PhonemeExpr parsePhonemeExpr(String string) {
        if (string.startsWith("(")) {
            if (!string.endsWith(")")) {
                throw new IllegalArgumentException("Phoneme starts with '(' so must end with ')'");
            }
            ArrayList<Rule$Phoneme> arrayList = new ArrayList<Rule$Phoneme>();
            String string2 = string.substring(1, string.length() - 1);
            for (String string3 : string2.split("[|]")) {
                arrayList.add(Rule.parsePhoneme(string3));
            }
            if (string2.startsWith("|") || string2.endsWith("|")) {
                arrayList.add(new Rule$Phoneme("", Languages.ANY_LANGUAGE));
            }
            return new Rule$PhonemeList(arrayList);
        }
        return Rule.parsePhoneme(string);
    }

    private static Map<String, List<Rule>> parseRules(Scanner scanner, String string) {
        HashMap<String, List<Rule>> hashMap = new HashMap<String, List<Rule>>();
        int n = 0;
        boolean bl = false;
        while (scanner.hasNextLine()) {
            Object object;
            String string2;
            ++n;
            String string3 = string2 = scanner.nextLine();
            if (bl) {
                if (!string3.endsWith("*/")) continue;
                bl = false;
                continue;
            }
            if (string3.startsWith("/*")) {
                bl = true;
                continue;
            }
            int n2 = string3.indexOf("//");
            if (n2 >= 0) {
                string3 = string3.substring(0, n2);
            }
            if ((string3 = string3.trim()).length() == 0) continue;
            if (string3.startsWith(HASH_INCLUDE)) {
                object = string3.substring(HASH_INCLUDE.length()).trim();
                if (((String)object).contains(" ")) {
                    throw new IllegalArgumentException("Malformed import statement '" + string2 + "' in " + string);
                }
                hashMap.putAll(Rule.parseRules(Rule.createScanner((String)object), string + "->" + (String)object));
                continue;
            }
            object = string3.split("\\s+");
            if (((String[])object).length != 4) {
                throw new IllegalArgumentException("Malformed rule statement split into " + ((Object)object).length + " parts: " + string2 + " in " + string);
            }
            try {
                String string4 = Rule.stripQuotes((String)object[0]);
                String string5 = Rule.stripQuotes((String)object[1]);
                String string6 = Rule.stripQuotes((String)object[2]);
                Rule$PhonemeExpr rule$PhonemeExpr = Rule.parsePhonemeExpr(Rule.stripQuotes((String)object[3]));
                int n3 = n;
                Rule$2 rule$2 = new Rule$2(string4, string5, string6, rule$PhonemeExpr, n3, string, string4, string5, string6);
                String string7 = rule$2.pattern.substring(0, 1);
                ArrayList<Rule$2> arrayList = (ArrayList<Rule$2>)hashMap.get(string7);
                if (arrayList == null) {
                    arrayList = new ArrayList<Rule$2>();
                    hashMap.put(string7, arrayList);
                }
                arrayList.add(rule$2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Problem parsing line '" + n + "' in " + string, illegalArgumentException);
            }
        }
        return hashMap;
    }

    private static Rule$RPattern pattern(String string) {
        boolean bl;
        boolean bl2 = string.startsWith("^");
        String string2 = string.substring(bl2 ? 1 : 0, (bl = string.endsWith("$")) ? string.length() - 1 : string.length());
        boolean bl3 = string2.contains("[");
        if (!bl3) {
            if (bl2 && bl) {
                if (string2.length() == 0) {
                    return new Rule$3();
                }
                return new Rule$4(string2);
            }
            if ((bl2 || bl) && string2.length() == 0) {
                return ALL_STRINGS_RMATCHER;
            }
            if (bl2) {
                return new Rule$5(string2);
            }
            if (bl) {
                return new Rule$6(string2);
            }
        } else {
            String string3;
            boolean bl4 = string2.startsWith("[");
            boolean bl5 = string2.endsWith("]");
            if (bl4 && bl5 && !(string3 = string2.substring(1, string2.length() - 1)).contains("[")) {
                boolean bl6;
                boolean bl7 = string3.startsWith("^");
                if (bl7) {
                    string3 = string3.substring(1);
                }
                String string4 = string3;
                boolean bl8 = bl6 = !bl7;
                if (bl2 && bl) {
                    return new Rule$7(string4, bl6);
                }
                if (bl2) {
                    return new Rule$8(string4, bl6);
                }
                if (bl) {
                    return new Rule$9(string4, bl6);
                }
            }
        }
        return new Rule$10(string);
    }

    private static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static String stripQuotes(String string) {
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1);
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Rule(String string, String string2, String string3, Rule$PhonemeExpr rule$PhonemeExpr) {
        this.pattern = string;
        this.lContext = Rule.pattern(string2 + "$");
        this.rContext = Rule.pattern("^" + string3);
        this.phoneme = rule$PhonemeExpr;
    }

    public Rule$RPattern getLContext() {
        return this.lContext;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Rule$PhonemeExpr getPhoneme() {
        return this.phoneme;
    }

    public Rule$RPattern getRContext() {
        return this.rContext;
    }

    public boolean patternAndContextMatches(CharSequence charSequence, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Can not match pattern at negative indexes");
        }
        int n2 = this.pattern.length();
        int n3 = n + n2;
        if (n3 > charSequence.length()) {
            return false;
        }
        if (!charSequence.subSequence(n, n3).equals(this.pattern)) {
            return false;
        }
        if (!this.rContext.isMatch(charSequence.subSequence(n3, charSequence.length()))) {
            return false;
        }
        return this.lContext.isMatch(charSequence.subSequence(0, n));
    }

    static /* synthetic */ boolean access$100(CharSequence charSequence, CharSequence charSequence2) {
        return Rule.startsWith(charSequence, charSequence2);
    }

    static /* synthetic */ boolean access$200(CharSequence charSequence, CharSequence charSequence2) {
        return Rule.endsWith(charSequence, charSequence2);
    }

    static /* synthetic */ boolean access$300(CharSequence charSequence, char c2) {
        return Rule.contains(charSequence, c2);
    }

    static {
        for (NameType nameType : NameType.values()) {
            EnumMap enumMap = new EnumMap(RuleType.class);
            for (RuleType ruleType : RuleType.values()) {
                HashMap<String, Map<String, List<Rule>>> hashMap = new HashMap<String, Map<String, List<Rule>>>();
                Languages languages = Languages.getInstance(nameType);
                for (String string : languages.getLanguages()) {
                    try {
                        hashMap.put(string, Rule.parseRules(Rule.createScanner(nameType, ruleType, string), Rule.createResourceName(nameType, ruleType, string)));
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new IllegalStateException("Problem processing " + Rule.createResourceName(nameType, ruleType, string), illegalStateException);
                    }
                }
                if (!ruleType.equals((Object)RuleType.RULES)) {
                    hashMap.put("common", Rule.parseRules(Rule.createScanner(nameType, ruleType, "common"), Rule.createResourceName(nameType, ruleType, "common")));
                }
                enumMap.put(ruleType, Collections.unmodifiableMap(hashMap));
            }
            RULES.put(nameType, Collections.unmodifiableMap(enumMap));
        }
    }
}

