/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.arj;

import java.io.File;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.arj.LocalFileHeader;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public class ArjArchiveEntry
implements ArchiveEntry {
    private final LocalFileHeader localFileHeader;

    public ArjArchiveEntry() {
        this.localFileHeader = new LocalFileHeader();
    }

    ArjArchiveEntry(LocalFileHeader localFileHeader) {
        this.localFileHeader = localFileHeader;
    }

    @Override
    public String getName() {
        if ((this.localFileHeader.arjFlags & 0x10) != 0) {
            return this.localFileHeader.name.replaceAll("/", Matcher.quoteReplacement(File.separator));
        }
        return this.localFileHeader.name;
    }

    @Override
    public long getSize() {
        return this.localFileHeader.originalSize;
    }

    @Override
    public boolean isDirectory() {
        return this.localFileHeader.fileType == 3;
    }

    @Override
    public Date getLastModifiedDate() {
        long l = this.isHostOsUnix() ? (long)this.localFileHeader.dateTimeModified * 1000L : ZipUtil.dosToJavaTime(0xFFFFFFFFL & (long)this.localFileHeader.dateTimeModified);
        return new Date(l);
    }

    public int getMode() {
        return this.localFileHeader.fileAccessMode;
    }

    public int getUnixMode() {
        return this.isHostOsUnix() ? this.getMode() : 0;
    }

    public int getHostOs() {
        return this.localFileHeader.hostOS;
    }

    public boolean isHostOsUnix() {
        return this.getHostOs() == 2 || this.getHostOs() == 8;
    }

    int getMethod() {
        return this.localFileHeader.method;
    }
}

