/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.arj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.arj.ArjArchiveEntry;
import org.apache.commons.compress.archivers.arj.LocalFileHeader;
import org.apache.commons.compress.archivers.arj.MainHeader;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.CRC32VerifyingInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ArjArchiveInputStream
extends ArchiveInputStream {
    private static final int ARJ_MAGIC_1 = 96;
    private static final int ARJ_MAGIC_2 = 234;
    private final DataInputStream in;
    private final String charsetName;
    private final MainHeader mainHeader;
    private LocalFileHeader currentLocalFileHeader = null;
    private InputStream currentInputStream = null;

    public ArjArchiveInputStream(InputStream inputStream, String string) {
        this.in = new DataInputStream(inputStream);
        this.charsetName = string;
        try {
            this.mainHeader = this.readMainHeader();
            if ((this.mainHeader.arjFlags & 1) != 0) {
                throw new ArchiveException("Encrypted ARJ files are unsupported");
            }
            if ((this.mainHeader.arjFlags & 4) != 0) {
                throw new ArchiveException("Multi-volume ARJ files are unsupported");
            }
        }
        catch (IOException iOException) {
            throw new ArchiveException(iOException.getMessage(), iOException);
        }
    }

    public ArjArchiveInputStream(InputStream inputStream) {
        this(inputStream, "CP437");
    }

    @Override
    public void close() {
        this.in.close();
    }

    private int read8(DataInputStream dataInputStream) {
        int n = dataInputStream.readUnsignedByte();
        this.count(1);
        return n;
    }

    private int read16(DataInputStream dataInputStream) {
        int n = dataInputStream.readUnsignedShort();
        this.count(2);
        return Integer.reverseBytes(n) >>> 16;
    }

    private int read32(DataInputStream dataInputStream) {
        int n = dataInputStream.readInt();
        this.count(4);
        return Integer.reverseBytes(n);
    }

    private String readString(DataInputStream dataInputStream) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = dataInputStream.readUnsignedByte()) != 0) {
            byteArrayOutputStream.write(n);
        }
        if (this.charsetName != null) {
            return new String(byteArrayOutputStream.toByteArray(), this.charsetName);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private void readFully(DataInputStream dataInputStream, byte[] byArray) {
        dataInputStream.readFully(byArray);
        this.count(byArray.length);
    }

    private byte[] readHeader() {
        boolean bl = false;
        byte[] byArray = null;
        do {
            int n = 0;
            int n2 = this.read8(this.in);
            do {
                n = n2;
                n2 = this.read8(this.in);
            } while (n != 96 && n2 != 234);
            int n3 = this.read16(this.in);
            if (n3 == 0) {
                return null;
            }
            if (n3 > 2600) continue;
            byArray = new byte[n3];
            this.readFully(this.in, byArray);
            long l = (long)this.read32(this.in) & 0xFFFFFFFFL;
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            if (l != cRC32.getValue()) continue;
            bl = true;
        } while (!bl);
        return byArray;
    }

    private MainHeader readMainHeader() {
        byte[] byArray = this.readHeader();
        if (byArray == null) {
            throw new IOException("Archive ends without any headers");
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        int n = dataInputStream.readUnsignedByte();
        byte[] byArray2 = new byte[n - 1];
        dataInputStream.readFully(byArray2);
        DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray2));
        MainHeader mainHeader = new MainHeader();
        mainHeader.archiverVersionNumber = dataInputStream2.readUnsignedByte();
        mainHeader.minVersionToExtract = dataInputStream2.readUnsignedByte();
        mainHeader.hostOS = dataInputStream2.readUnsignedByte();
        mainHeader.arjFlags = dataInputStream2.readUnsignedByte();
        mainHeader.securityVersion = dataInputStream2.readUnsignedByte();
        mainHeader.fileType = dataInputStream2.readUnsignedByte();
        mainHeader.reserved = dataInputStream2.readUnsignedByte();
        mainHeader.dateTimeCreated = this.read32(dataInputStream2);
        mainHeader.dateTimeModified = this.read32(dataInputStream2);
        mainHeader.archiveSize = 0xFFFFFFFFL & (long)this.read32(dataInputStream2);
        mainHeader.securityEnvelopeFilePosition = this.read32(dataInputStream2);
        mainHeader.fileSpecPosition = this.read16(dataInputStream2);
        mainHeader.securityEnvelopeLength = this.read16(dataInputStream2);
        this.pushedBackBytes(20L);
        mainHeader.encryptionVersion = dataInputStream2.readUnsignedByte();
        mainHeader.lastChapter = dataInputStream2.readUnsignedByte();
        if (n >= 33) {
            mainHeader.arjProtectionFactor = dataInputStream2.readUnsignedByte();
            mainHeader.arjFlags2 = dataInputStream2.readUnsignedByte();
            dataInputStream2.readUnsignedByte();
            dataInputStream2.readUnsignedByte();
        }
        mainHeader.name = this.readString(dataInputStream);
        mainHeader.comment = this.readString(dataInputStream);
        int n2 = this.read16(this.in);
        if (n2 > 0) {
            mainHeader.extendedHeaderBytes = new byte[n2];
            this.readFully(this.in, mainHeader.extendedHeaderBytes);
            long l = 0xFFFFFFFFL & (long)this.read32(this.in);
            CRC32 cRC32 = new CRC32();
            cRC32.update(mainHeader.extendedHeaderBytes);
            if (l != cRC32.getValue()) {
                throw new IOException("Extended header CRC32 verification failure");
            }
        }
        return mainHeader;
    }

    /*
     * Exception decompiling
     */
    private LocalFileHeader readLocalFileHeader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void readExtraData(int n, DataInputStream dataInputStream, LocalFileHeader localFileHeader) {
        if (n >= 33) {
            localFileHeader.extendedFilePosition = this.read32(dataInputStream);
            if (n >= 45) {
                localFileHeader.dateTimeAccessed = this.read32(dataInputStream);
                localFileHeader.dateTimeCreated = this.read32(dataInputStream);
                localFileHeader.originalSizeEvenForVolumes = this.read32(dataInputStream);
                this.pushedBackBytes(12L);
            }
            this.pushedBackBytes(4L);
        }
    }

    public static boolean matches(byte[] byArray, int n) {
        return n >= 2 && (0xFF & byArray[0]) == 96 && (0xFF & byArray[1]) == 234;
    }

    public String getArchiveName() {
        return this.mainHeader.name;
    }

    public String getArchiveComment() {
        return this.mainHeader.comment;
    }

    @Override
    public ArjArchiveEntry getNextEntry() {
        if (this.currentInputStream != null) {
            IOUtils.skip(this.currentInputStream, Long.MAX_VALUE);
            this.currentInputStream.close();
            this.currentLocalFileHeader = null;
            this.currentInputStream = null;
        }
        this.currentLocalFileHeader = this.readLocalFileHeader();
        if (this.currentLocalFileHeader != null) {
            this.currentInputStream = new BoundedInputStream(this.in, this.currentLocalFileHeader.compressedSize);
            if (this.currentLocalFileHeader.method == 0) {
                this.currentInputStream = new CRC32VerifyingInputStream(this.currentInputStream, this.currentLocalFileHeader.originalSize, this.currentLocalFileHeader.originalCrc32);
            }
            return new ArjArchiveEntry(this.currentLocalFileHeader);
        }
        this.currentInputStream = null;
        return null;
    }

    @Override
    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        return archiveEntry instanceof ArjArchiveEntry && ((ArjArchiveEntry)archiveEntry).getMethod() == 0;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this.currentLocalFileHeader == null) {
            throw new IllegalStateException("No current arj entry");
        }
        if (this.currentLocalFileHeader.method != 0) {
            throw new IOException("Unsupported compression method " + this.currentLocalFileHeader.method);
        }
        return this.currentInputStream.read(byArray, n, n2);
    }
}

