/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.util.Arrays;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.utils.ByteUtils;

class DumpArchiveUtil {
    private DumpArchiveUtil() {
    }

    public static int calculateChecksum(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            n += DumpArchiveUtil.convert32(byArray, 4 * i);
        }
        return 84446 - (n - DumpArchiveUtil.convert32(byArray, 28));
    }

    public static final boolean verify(byte[] byArray) {
        int n = DumpArchiveUtil.convert32(byArray, 24);
        if (n != 60012) {
            return false;
        }
        int n2 = DumpArchiveUtil.convert32(byArray, 28);
        return n2 == DumpArchiveUtil.calculateChecksum(byArray);
    }

    public static final int getIno(byte[] byArray) {
        return DumpArchiveUtil.convert32(byArray, 20);
    }

    public static final long convert64(byte[] byArray, int n) {
        return ByteUtils.fromLittleEndian(byArray, n, 8);
    }

    public static final int convert32(byte[] byArray, int n) {
        return (int)ByteUtils.fromLittleEndian(byArray, n, 4);
    }

    public static final int convert16(byte[] byArray, int n) {
        return (int)ByteUtils.fromLittleEndian(byArray, n, 2);
    }

    static String decode(ZipEncoding zipEncoding, byte[] byArray, int n, int n2) {
        return zipEncoding.decode(Arrays.copyOfRange(byArray, n, n + n2));
    }
}

