/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.File;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.examples.Archiver$1;
import org.apache.commons.compress.archivers.examples.Archiver$2;
import org.apache.commons.compress.archivers.examples.Archiver$3;
import org.apache.commons.compress.archivers.examples.Archiver$4;
import org.apache.commons.compress.archivers.examples.Archiver$5;
import org.apache.commons.compress.archivers.examples.Archiver$6;
import org.apache.commons.compress.archivers.examples.Archiver$ArchiveEntryConsumer;
import org.apache.commons.compress.archivers.examples.Archiver$ArchiveEntryCreator;
import org.apache.commons.compress.archivers.examples.Archiver$Finisher;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class Archiver {
    public void create(String string, File file, File file2) {
        if (this.prefersSeekableByteChannel(string)) {
            try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                this.create(string, fileChannel, file2);
            }
            return;
        }
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            this.create(string, outputStream, file2);
        }
    }

    public void create(String string, OutputStream outputStream, File file) {
        this.create(new ArchiveStreamFactory().createArchiveOutputStream(string, outputStream), file);
    }

    public void create(String string, SeekableByteChannel seekableByteChannel, File file) {
        if (!this.prefersSeekableByteChannel(string)) {
            this.create(string, Channels.newOutputStream(seekableByteChannel), file);
        } else if ("zip".equalsIgnoreCase(string)) {
            this.create(new ZipArchiveOutputStream(seekableByteChannel), file);
        } else if ("7z".equalsIgnoreCase(string)) {
            this.create(new SevenZOutputFile(seekableByteChannel), file);
        } else {
            throw new ArchiveException("don't know how to handle format " + string);
        }
    }

    public void create(ArchiveOutputStream archiveOutputStream, File file) {
        this.create(file, new Archiver$1(this, archiveOutputStream), new Archiver$2(this, archiveOutputStream), new Archiver$3(this, archiveOutputStream));
    }

    public void create(SevenZOutputFile sevenZOutputFile, File file) {
        this.create(file, new Archiver$4(this, sevenZOutputFile), new Archiver$5(this, sevenZOutputFile), new Archiver$6(this, sevenZOutputFile));
    }

    private boolean prefersSeekableByteChannel(String string) {
        return "zip".equalsIgnoreCase(string) || "7z".equalsIgnoreCase(string);
    }

    private void create(File file, Archiver$ArchiveEntryCreator archiver$ArchiveEntryCreator, Archiver$ArchiveEntryConsumer archiver$ArchiveEntryConsumer, Archiver$Finisher archiver$Finisher) {
        this.create("", file, archiver$ArchiveEntryCreator, archiver$ArchiveEntryConsumer);
        archiver$Finisher.finish();
    }

    private void create(String string, File file, Archiver$ArchiveEntryCreator archiver$ArchiveEntryCreator, Archiver$ArchiveEntryConsumer archiver$ArchiveEntryConsumer) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2 = string + file2.getName() + (file2.isDirectory() ? "/" : "");
            archiver$ArchiveEntryConsumer.accept(file2, archiver$ArchiveEntryCreator.create(file2, string2));
            if (!file2.isDirectory()) continue;
            this.create(string2, file2, archiver$ArchiveEntryCreator, archiver$ArchiveEntryConsumer);
        }
    }
}

