/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.examples.Expander$1;
import org.apache.commons.compress.archivers.examples.Expander$2;
import org.apache.commons.compress.archivers.examples.Expander$3;
import org.apache.commons.compress.archivers.examples.Expander$4;
import org.apache.commons.compress.archivers.examples.Expander$5;
import org.apache.commons.compress.archivers.examples.Expander$6;
import org.apache.commons.compress.archivers.examples.Expander$ArchiveEntrySupplier;
import org.apache.commons.compress.archivers.examples.Expander$EntryWriter;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class Expander {
    public void expand(File file, File file2) {
        String string = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            new ArchiveStreamFactory();
            string = ArchiveStreamFactory.detect(bufferedInputStream);
        }
        this.expand(string, file, file2);
    }

    public void expand(String string, File file, File file2) {
        if (this.prefersSeekableByteChannel(string)) {
            try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
                this.expand(string, fileChannel, file2);
            }
            return;
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            this.expand(string, bufferedInputStream, file2);
        }
    }

    public void expand(InputStream inputStream, File file) {
        this.expand(new ArchiveStreamFactory().createArchiveInputStream(inputStream), file);
    }

    public void expand(String string, InputStream inputStream, File file) {
        this.expand(new ArchiveStreamFactory().createArchiveInputStream(string, inputStream), file);
    }

    public void expand(String string, SeekableByteChannel seekableByteChannel, File file) {
        if (!this.prefersSeekableByteChannel(string)) {
            this.expand(string, Channels.newInputStream(seekableByteChannel), file);
        } else if ("zip".equalsIgnoreCase(string)) {
            this.expand(new ZipFile(seekableByteChannel), file);
        } else if ("7z".equalsIgnoreCase(string)) {
            this.expand(new SevenZFile(seekableByteChannel), file);
        } else {
            throw new ArchiveException("don't know how to handle format " + string);
        }
    }

    public void expand(ArchiveInputStream archiveInputStream, File file) {
        this.expand(new Expander$1(this, archiveInputStream), new Expander$2(this, archiveInputStream), file);
    }

    public void expand(ZipFile zipFile, File file) {
        Enumeration<ZipArchiveEntry> enumeration = zipFile.getEntries();
        this.expand(new Expander$3(this, enumeration, zipFile), new Expander$4(this, zipFile), file);
    }

    public void expand(SevenZFile sevenZFile, File file) {
        this.expand(new Expander$5(this, sevenZFile), new Expander$6(this, sevenZFile), file);
    }

    private boolean prefersSeekableByteChannel(String string) {
        return "zip".equalsIgnoreCase(string) || "7z".equalsIgnoreCase(string);
    }

    private void expand(Expander$ArchiveEntrySupplier expander$ArchiveEntrySupplier, Expander$EntryWriter expander$EntryWriter, File file) {
        String string = file.getCanonicalPath();
        ArchiveEntry archiveEntry = expander$ArchiveEntrySupplier.getNextReadableEntry();
        while (archiveEntry != null) {
            File file2 = new File(file, archiveEntry.getName());
            if (!file2.getCanonicalPath().startsWith(string)) {
                throw new IOException("expanding " + archiveEntry.getName() + " would create file outside of " + file);
            }
            if (archiveEntry.isDirectory()) {
                if (!file2.isDirectory() && !file2.mkdirs()) {
                    throw new IOException("failed to create directory " + file2);
                }
            } else {
                File file3 = file2.getParentFile();
                if (!file3.isDirectory() && !file3.mkdirs()) {
                    throw new IOException("failed to create directory " + file3);
                }
                try (OutputStream outputStream = Files.newOutputStream(file2.toPath(), new OpenOption[0]);){
                    expander$EntryWriter.writeEntryDataTo(archiveEntry, outputStream);
                }
            }
            archiveEntry = expander$ArchiveEntrySupplier.getNextReadableEntry();
        }
    }
}

