/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

class BoundedSeekableByteChannelInputStream
extends InputStream {
    private static final int MAX_BUF_LEN = 8192;
    private final ByteBuffer buffer;
    private final SeekableByteChannel channel;
    private long bytesRemaining;

    public BoundedSeekableByteChannelInputStream(SeekableByteChannel seekableByteChannel, long l) {
        this.channel = seekableByteChannel;
        this.bytesRemaining = l;
        this.buffer = l < 8192L && l > 0L ? ByteBuffer.allocate((int)l) : ByteBuffer.allocate(8192);
    }

    @Override
    public int read() {
        if (this.bytesRemaining > 0L) {
            --this.bytesRemaining;
            int n = this.read(1);
            if (n < 0) {
                return n;
            }
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        ByteBuffer byteBuffer;
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int n4 = n2;
        if ((long)n4 > this.bytesRemaining) {
            n4 = (int)this.bytesRemaining;
        }
        if (n4 <= this.buffer.capacity()) {
            byteBuffer = this.buffer;
            n3 = this.read(n4);
        } else {
            byteBuffer = ByteBuffer.allocate(n4);
            n3 = this.channel.read(byteBuffer);
            byteBuffer.flip();
        }
        if (n3 >= 0) {
            byteBuffer.get(byArray, n, n3);
            this.bytesRemaining -= (long)n3;
        }
        return n3;
    }

    private int read(int n) {
        this.buffer.rewind().limit(n);
        int n2 = this.channel.read(this.buffer);
        this.buffer.flip();
        return n2;
    }

    @Override
    public void close() {
    }
}

