/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;
import org.tukaani.xz.DeltaOptions;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.FinishableWrapperOutputStream;
import org.tukaani.xz.UnsupportedOptionsException;

class DeltaDecoder
extends CoderBase {
    DeltaDecoder() {
        super(Number.class);
    }

    @Override
    InputStream decode(String string, InputStream inputStream, long l, Coder coder, byte[] byArray) {
        return new DeltaOptions(this.getOptionsFromCoder(coder)).getInputStream(inputStream);
    }

    @Override
    OutputStream encode(OutputStream outputStream, Object object) {
        int n = DeltaDecoder.numberOptionOrDefault(object, 1);
        try {
            return new DeltaOptions(n).getOutputStream((FinishableOutputStream)new FinishableWrapperOutputStream(outputStream));
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new IOException(unsupportedOptionsException.getMessage());
        }
    }

    @Override
    byte[] getOptionsAsProperties(Object object) {
        return new byte[]{(byte)(DeltaDecoder.numberOptionOrDefault(object, 1) - 1)};
    }

    @Override
    Object getOptionsFromCoder(Coder coder, InputStream inputStream) {
        return this.getOptionsFromCoder(coder);
    }

    private int getOptionsFromCoder(Coder coder) {
        if (coder.properties == null || coder.properties.length == 0) {
            return 1;
        }
        return (0xFF & coder.properties[0]) + 1;
    }
}

