/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.FlushShieldFilterOutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.LZMAOutputStream;

class LZMADecoder
extends CoderBase {
    LZMADecoder() {
        super(LZMA2Options.class, Number.class);
    }

    @Override
    InputStream decode(String string, InputStream inputStream, long l, Coder coder, byte[] byArray) {
        byte by = coder.properties[0];
        int n = this.getDictionarySize(coder);
        if (n > 0x7FFFFFF0) {
            throw new IOException("Dictionary larger than 4GiB maximum size used in " + string);
        }
        return new LZMAInputStream(inputStream, l, by, n);
    }

    @Override
    OutputStream encode(OutputStream outputStream, Object object) {
        return new FlushShieldFilterOutputStream((OutputStream)new LZMAOutputStream(outputStream, this.getOptions(object), false));
    }

    @Override
    byte[] getOptionsAsProperties(Object object) {
        LZMA2Options lZMA2Options = this.getOptions(object);
        byte by = (byte)((lZMA2Options.getPb() * 5 + lZMA2Options.getLp()) * 9 + lZMA2Options.getLc());
        int n = lZMA2Options.getDictSize();
        byte[] byArray = new byte[5];
        byArray[0] = by;
        ByteUtils.toLittleEndian(byArray, n, 1, 4);
        return byArray;
    }

    @Override
    Object getOptionsFromCoder(Coder coder, InputStream inputStream) {
        byte by = coder.properties[0];
        int n = by & 0xFF;
        int n2 = n / 45;
        int n3 = (n -= n2 * 9 * 5) / 9;
        int n4 = n - n3 * 9;
        LZMA2Options lZMA2Options = new LZMA2Options();
        lZMA2Options.setPb(n2);
        lZMA2Options.setLcLp(n4, n3);
        lZMA2Options.setDictSize(this.getDictionarySize(coder));
        return lZMA2Options;
    }

    private int getDictionarySize(Coder coder) {
        return (int)ByteUtils.fromLittleEndian(coder.properties, 1, 4);
    }

    private LZMA2Options getOptions(Object object) {
        if (object instanceof LZMA2Options) {
            return (LZMA2Options)object;
        }
        LZMA2Options lZMA2Options = new LZMA2Options();
        lZMA2Options.setDictSize(this.numberOptionOrDefault(object));
        return lZMA2Options;
    }

    private int numberOptionOrDefault(Object object) {
        return LZMADecoder.numberOptionOrDefault(object, 0x800000);
    }
}

