/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream$CompressedEntry;
import org.apache.commons.compress.archivers.zip.StreamCompressor;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.FileBasedScatterGatherBackingStore;
import org.apache.commons.compress.parallel.ScatterGatherBackingStore;
import org.apache.commons.compress.utils.BoundedInputStream;

public class ScatterZipOutputStream
implements Closeable {
    private final Queue<ScatterZipOutputStream$CompressedEntry> items = new ConcurrentLinkedQueue<ScatterZipOutputStream$CompressedEntry>();
    private final ScatterGatherBackingStore backingStore;
    private final StreamCompressor streamCompressor;

    public ScatterZipOutputStream(ScatterGatherBackingStore scatterGatherBackingStore, StreamCompressor streamCompressor) {
        this.backingStore = scatterGatherBackingStore;
        this.streamCompressor = streamCompressor;
    }

    public void addArchiveEntry(ZipArchiveEntryRequest zipArchiveEntryRequest) {
        try (InputStream inputStream = zipArchiveEntryRequest.getPayloadStream();){
            this.streamCompressor.deflate(inputStream, zipArchiveEntryRequest.getMethod());
        }
        this.items.add(new ScatterZipOutputStream$CompressedEntry(zipArchiveEntryRequest, this.streamCompressor.getCrc32(), this.streamCompressor.getBytesWrittenForLastEntry(), this.streamCompressor.getBytesRead()));
    }

    public void writeTo(ZipArchiveOutputStream zipArchiveOutputStream) {
        this.backingStore.closeForWriting();
        try (InputStream inputStream = this.backingStore.getInputStream();){
            for (ScatterZipOutputStream$CompressedEntry scatterZipOutputStream$CompressedEntry : this.items) {
                BoundedInputStream boundedInputStream = new BoundedInputStream(inputStream, scatterZipOutputStream$CompressedEntry.compressedSize);
                Throwable throwable = null;
                try {
                    zipArchiveOutputStream.addRawArchiveEntry(scatterZipOutputStream$CompressedEntry.transferToArchiveEntry(), boundedInputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (boundedInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            boundedInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    boundedInputStream.close();
                }
            }
        }
    }

    @Override
    public void close() {
        this.backingStore.close();
        this.streamCompressor.close();
    }

    public static ScatterZipOutputStream fileBased(File file) {
        return ScatterZipOutputStream.fileBased(file, -1);
    }

    public static ScatterZipOutputStream fileBased(File file, int n) {
        FileBasedScatterGatherBackingStore fileBasedScatterGatherBackingStore = new FileBasedScatterGatherBackingStore(file);
        StreamCompressor streamCompressor = StreamCompressor.create(n, fileBasedScatterGatherBackingStore);
        return new ScatterZipOutputStream(fileBasedScatterGatherBackingStore, streamCompressor);
    }
}

