/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.Date;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class X000A_NTFS
implements ZipExtraField {
    private static final ZipShort HEADER_ID = new ZipShort(10);
    private static final ZipShort TIME_ATTR_TAG = new ZipShort(1);
    private static final ZipShort TIME_ATTR_SIZE = new ZipShort(24);
    private ZipEightByteInteger modifyTime = ZipEightByteInteger.ZERO;
    private ZipEightByteInteger accessTime = ZipEightByteInteger.ZERO;
    private ZipEightByteInteger createTime = ZipEightByteInteger.ZERO;
    private static final long EPOCH_OFFSET = -116444736000000000L;

    @Override
    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(32);
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    @Override
    public byte[] getLocalFileDataData() {
        byte[] byArray = new byte[this.getLocalFileDataLength().getValue()];
        int n = 4;
        System.arraycopy(TIME_ATTR_TAG.getBytes(), 0, byArray, n, 2);
        System.arraycopy(TIME_ATTR_SIZE.getBytes(), 0, byArray, n += 2, 2);
        System.arraycopy(this.modifyTime.getBytes(), 0, byArray, n += 2, 8);
        System.arraycopy(this.accessTime.getBytes(), 0, byArray, n += 8, 8);
        System.arraycopy(this.createTime.getBytes(), 0, byArray, n += 8, 8);
        return byArray;
    }

    @Override
    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        n += 4;
        while (n + 4 <= n3) {
            ZipShort zipShort = new ZipShort(byArray, n);
            n += 2;
            if (zipShort.equals(TIME_ATTR_TAG)) {
                this.readTimeAttr(byArray, n, n3 - n);
                break;
            }
            ZipShort zipShort2 = new ZipShort(byArray, n);
            n += 2 + zipShort2.getValue();
        }
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] byArray, int n, int n2) {
        this.reset();
        this.parseFromLocalFileData(byArray, n, n2);
    }

    public ZipEightByteInteger getModifyTime() {
        return this.modifyTime;
    }

    public ZipEightByteInteger getAccessTime() {
        return this.accessTime;
    }

    public ZipEightByteInteger getCreateTime() {
        return this.createTime;
    }

    public Date getModifyJavaTime() {
        return X000A_NTFS.zipToDate(this.modifyTime);
    }

    public Date getAccessJavaTime() {
        return X000A_NTFS.zipToDate(this.accessTime);
    }

    public Date getCreateJavaTime() {
        return X000A_NTFS.zipToDate(this.createTime);
    }

    public void setModifyTime(ZipEightByteInteger zipEightByteInteger) {
        this.modifyTime = zipEightByteInteger == null ? ZipEightByteInteger.ZERO : zipEightByteInteger;
    }

    public void setAccessTime(ZipEightByteInteger zipEightByteInteger) {
        this.accessTime = zipEightByteInteger == null ? ZipEightByteInteger.ZERO : zipEightByteInteger;
    }

    public void setCreateTime(ZipEightByteInteger zipEightByteInteger) {
        this.createTime = zipEightByteInteger == null ? ZipEightByteInteger.ZERO : zipEightByteInteger;
    }

    public void setModifyJavaTime(Date date) {
        this.setModifyTime(X000A_NTFS.dateToZip(date));
    }

    public void setAccessJavaTime(Date date) {
        this.setAccessTime(X000A_NTFS.dateToZip(date));
    }

    public void setCreateJavaTime(Date date) {
        this.setCreateTime(X000A_NTFS.dateToZip(date));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0x000A Zip Extra Field:").append(" Modify:[").append(this.getModifyJavaTime()).append("] ").append(" Access:[").append(this.getAccessJavaTime()).append("] ").append(" Create:[").append(this.getCreateJavaTime()).append("] ");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof X000A_NTFS) {
            X000A_NTFS x000A_NTFS = (X000A_NTFS)object;
            return (this.modifyTime == x000A_NTFS.modifyTime || this.modifyTime != null && this.modifyTime.equals(x000A_NTFS.modifyTime)) && (this.accessTime == x000A_NTFS.accessTime || this.accessTime != null && this.accessTime.equals(x000A_NTFS.accessTime)) && (this.createTime == x000A_NTFS.createTime || this.createTime != null && this.createTime.equals(x000A_NTFS.createTime));
        }
        return false;
    }

    public int hashCode() {
        int n = -123;
        if (this.modifyTime != null) {
            n ^= this.modifyTime.hashCode();
        }
        if (this.accessTime != null) {
            n ^= Integer.rotateLeft(this.accessTime.hashCode(), 11);
        }
        if (this.createTime != null) {
            n ^= Integer.rotateLeft(this.createTime.hashCode(), 22);
        }
        return n;
    }

    private void reset() {
        this.modifyTime = ZipEightByteInteger.ZERO;
        this.accessTime = ZipEightByteInteger.ZERO;
        this.createTime = ZipEightByteInteger.ZERO;
    }

    private void readTimeAttr(byte[] byArray, int n, int n2) {
        ZipShort zipShort;
        if (n2 >= 26 && TIME_ATTR_SIZE.equals(zipShort = new ZipShort(byArray, n))) {
            this.modifyTime = new ZipEightByteInteger(byArray, n += 2);
            this.accessTime = new ZipEightByteInteger(byArray, n += 8);
            this.createTime = new ZipEightByteInteger(byArray, n += 8);
        }
    }

    private static ZipEightByteInteger dateToZip(Date date) {
        if (date == null) {
            return null;
        }
        return new ZipEightByteInteger(date.getTime() * 10000L - -116444736000000000L);
    }

    private static Date zipToDate(ZipEightByteInteger zipEightByteInteger) {
        if (zipEightByteInteger == null || ZipEightByteInteger.ZERO.equals(zipEightByteInteger)) {
            return null;
        }
        long l = (zipEightByteInteger.getLongValue() + -116444736000000000L) / 10000L;
        return new Date(l);
    }
}

