/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public class X7875_NewUnix
implements Serializable,
Cloneable,
ZipExtraField {
    private static final ZipShort HEADER_ID = new ZipShort(30837);
    private static final ZipShort ZERO = new ZipShort(0);
    private static final BigInteger ONE_THOUSAND = BigInteger.valueOf(1000L);
    private static final long serialVersionUID = 1L;
    private int version = 1;
    private BigInteger uid;
    private BigInteger gid;

    public X7875_NewUnix() {
        this.reset();
    }

    @Override
    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    public long getUID() {
        return ZipUtil.bigToLong(this.uid);
    }

    public long getGID() {
        return ZipUtil.bigToLong(this.gid);
    }

    public void setUID(long l) {
        this.uid = ZipUtil.longToBig(l);
    }

    public void setGID(long l) {
        this.gid = ZipUtil.longToBig(l);
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        byte[] byArray = X7875_NewUnix.trimLeadingZeroesForceMinLength(this.uid.toByteArray());
        int n = byArray == null ? 0 : byArray.length;
        byArray = X7875_NewUnix.trimLeadingZeroesForceMinLength(this.gid.toByteArray());
        int n2 = byArray == null ? 0 : byArray.length;
        return new ZipShort(3 + n + n2);
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        return ZERO;
    }

    @Override
    public byte[] getLocalFileDataData() {
        byte[] byArray = this.uid.toByteArray();
        byte[] byArray2 = this.gid.toByteArray();
        int n = (byArray = X7875_NewUnix.trimLeadingZeroesForceMinLength(byArray)) != null ? byArray.length : 0;
        byArray2 = X7875_NewUnix.trimLeadingZeroesForceMinLength(byArray2);
        int n2 = byArray2 != null ? byArray2.length : 0;
        byte[] byArray3 = new byte[3 + n + n2];
        if (byArray != null) {
            ZipUtil.reverse(byArray);
        }
        if (byArray2 != null) {
            ZipUtil.reverse(byArray2);
        }
        int n3 = 0;
        byArray3[n3++] = ZipUtil.unsignedIntToSignedByte(this.version);
        byArray3[n3++] = ZipUtil.unsignedIntToSignedByte(n);
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray3, n3, n);
        }
        n3 += n;
        byArray3[n3++] = ZipUtil.unsignedIntToSignedByte(n2);
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray3, n3, n2);
        }
        return byArray3;
    }

    @Override
    public byte[] getCentralDirectoryData() {
        return new byte[0];
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n, int n2) {
        this.reset();
        this.version = ZipUtil.signedByteToUnsignedInt(byArray[n++]);
        int n3 = ZipUtil.signedByteToUnsignedInt(byArray[n++]);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        n += n3;
        this.uid = new BigInteger(1, ZipUtil.reverse(byArray2));
        int n4 = ZipUtil.signedByteToUnsignedInt(byArray[n++]);
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n, byArray3, 0, n4);
        this.gid = new BigInteger(1, ZipUtil.reverse(byArray3));
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] byArray, int n, int n2) {
    }

    private void reset() {
        this.uid = ONE_THOUSAND;
        this.gid = ONE_THOUSAND;
    }

    public String toString() {
        return "0x7875 Zip Extra Field: UID=" + this.uid + " GID=" + this.gid;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object instanceof X7875_NewUnix) {
            X7875_NewUnix x7875_NewUnix = (X7875_NewUnix)object;
            return this.version == x7875_NewUnix.version && this.uid.equals(x7875_NewUnix.uid) && this.gid.equals(x7875_NewUnix.gid);
        }
        return false;
    }

    public int hashCode() {
        int n = -1234567 * this.version;
        n ^= Integer.rotateLeft(this.uid.hashCode(), 16);
        return n ^= this.gid.hashCode();
    }

    static byte[] trimLeadingZeroesForceMinLength(byte[] byArray) {
        if (byArray == null) {
            return byArray;
        }
        int n = 0;
        for (byte by : byArray) {
            if (by != 0) break;
            ++n;
        }
        boolean bl = true;
        byte[] byArray2 = new byte[Math.max(1, byArray.length - n)];
        int n2 = byArray2.length - (byArray.length - n);
        System.arraycopy(byArray, n, byArray2, n2, byArray2.length - n2);
        return byArray2;
    }
}

