/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnshrinkingInputStream;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry$NameSource;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipFile$1;
import org.apache.commons.compress.archivers.zip.ZipFile$2;
import org.apache.commons.compress.archivers.zip.ZipFile$BoundedFileChannelInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile$BoundedInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile$Entry;
import org.apache.commons.compress.archivers.zip.ZipFile$NameAndComment;
import org.apache.commons.compress.archivers.zip.ZipFile$StoredStatisticsStream;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipFile
implements Closeable {
    private static final int HASH_SIZE = 509;
    static final int NIBLET_MASK = 15;
    static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private static final byte[] ONE_ZERO_BYTE = new byte[1];
    private final List<ZipArchiveEntry> entries = new LinkedList<ZipArchiveEntry>();
    private final Map<String, LinkedList<ZipArchiveEntry>> nameMap = new HashMap<String, LinkedList<ZipArchiveEntry>>(509);
    private final String encoding;
    private final ZipEncoding zipEncoding;
    private final String archiveName;
    private final SeekableByteChannel archive;
    private final boolean useUnicodeExtraFields;
    private volatile boolean closed = true;
    private final byte[] dwordBuf = new byte[8];
    private final byte[] wordBuf = new byte[4];
    private final byte[] cfhBuf = new byte[42];
    private final byte[] shortBuf = new byte[2];
    private final ByteBuffer dwordBbuf = ByteBuffer.wrap(this.dwordBuf);
    private final ByteBuffer wordBbuf = ByteBuffer.wrap(this.wordBuf);
    private final ByteBuffer cfhBbuf = ByteBuffer.wrap(this.cfhBuf);
    private static final int CFH_LEN = 42;
    private static final long CFH_SIG = ZipLong.getValue(ZipArchiveOutputStream.CFH_SIG);
    static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_SIZE = 65557;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final int ZIP64_EOCDL_LENGTH = 20;
    private static final int ZIP64_EOCDL_LOCATOR_OFFSET = 8;
    private static final int ZIP64_EOCD_CFD_LOCATOR_OFFSET = 48;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;
    private final Comparator<ZipArchiveEntry> offsetComparator = new ZipFile$2(this);

    public ZipFile(File file) {
        this(file, "UTF8");
    }

    public ZipFile(String string) {
        this(new File(string), "UTF8");
    }

    public ZipFile(String string, String string2) {
        this(new File(string), string2, true);
    }

    public ZipFile(File file, String string) {
        this(file, string, true);
    }

    public ZipFile(File file, String string, boolean bl) {
        this(Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]), file.getAbsolutePath(), string, bl, true);
    }

    public ZipFile(SeekableByteChannel seekableByteChannel) {
        this(seekableByteChannel, "unknown archive", "UTF8", true);
    }

    public ZipFile(SeekableByteChannel seekableByteChannel, String string) {
        this(seekableByteChannel, "unknown archive", string, true);
    }

    public ZipFile(SeekableByteChannel seekableByteChannel, String string, String string2, boolean bl) {
        this(seekableByteChannel, string, string2, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipFile(SeekableByteChannel seekableByteChannel, String string, String string2, boolean bl, boolean bl2) {
        this.archiveName = string;
        this.encoding = string2;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string2);
        this.useUnicodeExtraFields = bl;
        this.archive = seekableByteChannel;
        boolean bl3 = false;
        try {
            Map<ZipArchiveEntry, ZipFile$NameAndComment> map = this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData(map);
            bl3 = true;
            boolean bl4 = this.closed = !bl3;
        }
        catch (Throwable throwable) {
            boolean bl5 = this.closed = !bl3;
            if (!bl3 && bl2) {
                IOUtils.closeQuietly(this.archive);
            }
            throw throwable;
        }
        if (!bl3 && bl2) {
            IOUtils.closeQuietly(this.archive);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() {
        this.closed = true;
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipFile) {
        IOUtils.closeQuietly(zipFile);
    }

    public Enumeration<ZipArchiveEntry> getEntries() {
        return Collections.enumeration(this.entries);
    }

    public Enumeration<ZipArchiveEntry> getEntriesInPhysicalOrder() {
        ZipArchiveEntry[] zipArchiveEntryArray = this.entries.toArray(new ZipArchiveEntry[this.entries.size()]);
        Arrays.sort(zipArchiveEntryArray, this.offsetComparator);
        return Collections.enumeration(Arrays.asList(zipArchiveEntryArray));
    }

    public ZipArchiveEntry getEntry(String string) {
        LinkedList<ZipArchiveEntry> linkedList = this.nameMap.get(string);
        return linkedList != null ? linkedList.getFirst() : null;
    }

    public Iterable<ZipArchiveEntry> getEntries(String string) {
        List<ZipArchiveEntry> list = (List<ZipArchiveEntry>)this.nameMap.get(string);
        return list != null ? list : Collections.emptyList();
    }

    public Iterable<ZipArchiveEntry> getEntriesInPhysicalOrder(String string) {
        ZipArchiveEntry[] zipArchiveEntryArray = new ZipArchiveEntry[]{};
        if (this.nameMap.containsKey(string)) {
            zipArchiveEntryArray = this.nameMap.get(string).toArray(zipArchiveEntryArray);
            Arrays.sort(zipArchiveEntryArray, this.offsetComparator);
        }
        return Arrays.asList(zipArchiveEntryArray);
    }

    public boolean canReadEntryData(ZipArchiveEntry zipArchiveEntry) {
        return ZipUtil.canHandleEntryData(zipArchiveEntry);
    }

    public InputStream getRawInputStream(ZipArchiveEntry zipArchiveEntry) {
        if (!(zipArchiveEntry instanceof ZipFile$Entry)) {
            return null;
        }
        long l = zipArchiveEntry.getDataOffset();
        return this.createBoundedInputStream(l, zipArchiveEntry.getCompressedSize());
    }

    public void copyRawEntries(ZipArchiveOutputStream zipArchiveOutputStream, ZipArchiveEntryPredicate zipArchiveEntryPredicate) {
        Enumeration<ZipArchiveEntry> enumeration = this.getEntriesInPhysicalOrder();
        while (enumeration.hasMoreElements()) {
            ZipArchiveEntry zipArchiveEntry = enumeration.nextElement();
            if (!zipArchiveEntryPredicate.test(zipArchiveEntry)) continue;
            zipArchiveOutputStream.addRawArchiveEntry(zipArchiveEntry, this.getRawInputStream(zipArchiveEntry));
        }
    }

    public InputStream getInputStream(ZipArchiveEntry zipArchiveEntry) {
        if (!(zipArchiveEntry instanceof ZipFile$Entry)) {
            return null;
        }
        ZipUtil.checkRequestedFeatures(zipArchiveEntry);
        long l = zipArchiveEntry.getDataOffset();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.createBoundedInputStream(l, zipArchiveEntry.getCompressedSize()));
        switch (ZipMethod.getMethodByCode(zipArchiveEntry.getMethod())) {
            case STORED: {
                return new ZipFile$StoredStatisticsStream(bufferedInputStream);
            }
            case UNSHRINKING: {
                return new UnshrinkingInputStream(bufferedInputStream);
            }
            case IMPLODING: {
                return new ExplodingInputStream(zipArchiveEntry.getGeneralPurposeBit().getSlidingDictionarySize(), zipArchiveEntry.getGeneralPurposeBit().getNumberOfShannonFanoTrees(), bufferedInputStream);
            }
            case DEFLATED: {
                Inflater inflater = new Inflater(true);
                return new ZipFile$1(this, new SequenceInputStream(bufferedInputStream, new ByteArrayInputStream(ONE_ZERO_BYTE)), inflater, inflater);
            }
            case BZIP2: {
                return new BZip2CompressorInputStream(bufferedInputStream);
            }
            case ENHANCED_DEFLATED: {
                return new Deflate64CompressorInputStream(bufferedInputStream);
            }
        }
        throw new ZipException("Found unsupported compression method " + zipArchiveEntry.getMethod());
    }

    public String getUnixSymlink(ZipArchiveEntry zipArchiveEntry) {
        if (zipArchiveEntry != null && zipArchiveEntry.isUnixSymlink()) {
            try (InputStream inputStream = this.getInputStream(zipArchiveEntry);){
                String string = this.zipEncoding.decode(IOUtils.toByteArray(inputStream));
                return string;
            }
        }
        return null;
    }

    protected void finalize() {
        try {
            if (!this.closed) {
                System.err.println("Cleaning up unclosed ZipFile for archive " + this.archiveName);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private Map<ZipArchiveEntry, ZipFile$NameAndComment> populateFromCentralDirectory() {
        HashMap<ZipArchiveEntry, ZipFile$NameAndComment> hashMap = new HashMap<ZipArchiveEntry, ZipFile$NameAndComment>();
        this.positionAtCentralDirectory();
        this.wordBbuf.rewind();
        IOUtils.readFully(this.archive, this.wordBbuf);
        long l = ZipLong.getValue(this.wordBuf);
        if (l != CFH_SIG && this.startsWithLocalFileHeader()) {
            throw new IOException("central directory is empty, can't expand corrupt archive.");
        }
        while (l == CFH_SIG) {
            this.readCentralDirectoryEntry(hashMap);
            this.wordBbuf.rewind();
            IOUtils.readFully(this.archive, this.wordBbuf);
            l = ZipLong.getValue(this.wordBuf);
        }
        return hashMap;
    }

    private void readCentralDirectoryEntry(Map<ZipArchiveEntry, ZipFile$NameAndComment> map) {
        ZipEncoding zipEncoding;
        this.cfhBbuf.rewind();
        IOUtils.readFully(this.archive, this.cfhBbuf);
        int n = 0;
        ZipFile$Entry zipFile$Entry = new ZipFile$Entry();
        int n2 = ZipShort.getValue(this.cfhBuf, n);
        zipFile$Entry.setVersionMadeBy(n2);
        zipFile$Entry.setPlatform(n2 >> 8 & 0xF);
        zipFile$Entry.setVersionRequired(ZipShort.getValue(this.cfhBuf, n += 2));
        GeneralPurposeBit generalPurposeBit = GeneralPurposeBit.parse(this.cfhBuf, n += 2);
        boolean bl = generalPurposeBit.usesUTF8ForNames();
        ZipEncoding zipEncoding2 = zipEncoding = bl ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        if (bl) {
            zipFile$Entry.setNameSource(ZipArchiveEntry$NameSource.NAME_WITH_EFS_FLAG);
        }
        zipFile$Entry.setGeneralPurposeBit(generalPurposeBit);
        zipFile$Entry.setRawFlag(ZipShort.getValue(this.cfhBuf, n));
        zipFile$Entry.setMethod(ZipShort.getValue(this.cfhBuf, n += 2));
        long l = ZipUtil.dosToJavaTime(ZipLong.getValue(this.cfhBuf, n += 2));
        zipFile$Entry.setTime(l);
        zipFile$Entry.setCrc(ZipLong.getValue(this.cfhBuf, n += 4));
        zipFile$Entry.setCompressedSize(ZipLong.getValue(this.cfhBuf, n += 4));
        zipFile$Entry.setSize(ZipLong.getValue(this.cfhBuf, n += 4));
        int n3 = ZipShort.getValue(this.cfhBuf, n += 4);
        int n4 = ZipShort.getValue(this.cfhBuf, n += 2);
        int n5 = ZipShort.getValue(this.cfhBuf, n += 2);
        int n6 = ZipShort.getValue(this.cfhBuf, n += 2);
        zipFile$Entry.setInternalAttributes(ZipShort.getValue(this.cfhBuf, n += 2));
        zipFile$Entry.setExternalAttributes(ZipLong.getValue(this.cfhBuf, n += 2));
        byte[] byArray = new byte[n3];
        IOUtils.readFully(this.archive, ByteBuffer.wrap(byArray));
        zipFile$Entry.setName(zipEncoding.decode(byArray), byArray);
        zipFile$Entry.setLocalHeaderOffset(ZipLong.getValue(this.cfhBuf, n += 4));
        this.entries.add(zipFile$Entry);
        byte[] byArray2 = new byte[n4];
        IOUtils.readFully(this.archive, ByteBuffer.wrap(byArray2));
        zipFile$Entry.setCentralDirectoryExtra(byArray2);
        this.setSizesAndOffsetFromZip64Extra(zipFile$Entry, n6);
        byte[] byArray3 = new byte[n5];
        IOUtils.readFully(this.archive, ByteBuffer.wrap(byArray3));
        zipFile$Entry.setComment(zipEncoding.decode(byArray3));
        if (!bl && this.useUnicodeExtraFields) {
            map.put(zipFile$Entry, new ZipFile$NameAndComment(byArray, byArray3, null));
        }
    }

    private void setSizesAndOffsetFromZip64Extra(ZipArchiveEntry zipArchiveEntry, int n) {
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (zip64ExtendedInformationExtraField != null) {
            boolean bl = zipArchiveEntry.getSize() == 0xFFFFFFFFL;
            boolean bl2 = zipArchiveEntry.getCompressedSize() == 0xFFFFFFFFL;
            boolean bl3 = zipArchiveEntry.getLocalHeaderOffset() == 0xFFFFFFFFL;
            zip64ExtendedInformationExtraField.reparseCentralDirectoryData(bl, bl2, bl3, n == 65535);
            if (bl) {
                zipArchiveEntry.setSize(zip64ExtendedInformationExtraField.getSize().getLongValue());
            } else if (bl2) {
                zip64ExtendedInformationExtraField.setSize(new ZipEightByteInteger(zipArchiveEntry.getSize()));
            }
            if (bl2) {
                zipArchiveEntry.setCompressedSize(zip64ExtendedInformationExtraField.getCompressedSize().getLongValue());
            } else if (bl) {
                zip64ExtendedInformationExtraField.setCompressedSize(new ZipEightByteInteger(zipArchiveEntry.getCompressedSize()));
            }
            if (bl3) {
                zipArchiveEntry.setLocalHeaderOffset(zip64ExtendedInformationExtraField.getRelativeHeaderOffset().getLongValue());
            }
        }
    }

    private void positionAtCentralDirectory() {
        boolean bl;
        this.positionAtEndOfCentralDirectoryRecord();
        boolean bl2 = false;
        boolean bl3 = bl = this.archive.position() > 20L;
        if (bl) {
            this.archive.position(this.archive.position() - 20L);
            this.wordBbuf.rewind();
            IOUtils.readFully(this.archive, this.wordBbuf);
            bl2 = Arrays.equals(ZipArchiveOutputStream.ZIP64_EOCD_LOC_SIG, this.wordBuf);
        }
        if (!bl2) {
            if (bl) {
                this.skipBytes(16);
            }
            this.positionAtCentralDirectory32();
        } else {
            this.positionAtCentralDirectory64();
        }
    }

    private void positionAtCentralDirectory64() {
        this.skipBytes(4);
        this.dwordBbuf.rewind();
        IOUtils.readFully(this.archive, this.dwordBbuf);
        this.archive.position(ZipEightByteInteger.getLongValue(this.dwordBuf));
        this.wordBbuf.rewind();
        IOUtils.readFully(this.archive, this.wordBbuf);
        if (!Arrays.equals(this.wordBuf, ZipArchiveOutputStream.ZIP64_EOCD_SIG)) {
            throw new ZipException("archive's ZIP64 end of central directory locator is corrupt.");
        }
        this.skipBytes(44);
        this.dwordBbuf.rewind();
        IOUtils.readFully(this.archive, this.dwordBbuf);
        this.archive.position(ZipEightByteInteger.getLongValue(this.dwordBuf));
    }

    private void positionAtCentralDirectory32() {
        this.skipBytes(16);
        this.wordBbuf.rewind();
        IOUtils.readFully(this.archive, this.wordBbuf);
        this.archive.position(ZipLong.getValue(this.wordBuf));
    }

    private void positionAtEndOfCentralDirectoryRecord() {
        boolean bl = this.tryToLocateSignature(22L, 65557L, ZipArchiveOutputStream.EOCD_SIG);
        if (!bl) {
            throw new ZipException("archive is not a ZIP archive");
        }
    }

    private boolean tryToLocateSignature(long l, long l2, byte[] byArray) {
        long l3;
        boolean bl = false;
        long l4 = Math.max(0L, this.archive.size() - l2);
        if (l3 >= 0L) {
            for (l3 = this.archive.size() - l; l3 >= l4; --l3) {
                this.archive.position(l3);
                try {
                    this.wordBbuf.rewind();
                    IOUtils.readFully(this.archive, this.wordBbuf);
                    this.wordBbuf.flip();
                }
                catch (EOFException eOFException) {
                    break;
                }
                byte by = this.wordBbuf.get();
                if (by != byArray[0] || (by = this.wordBbuf.get()) != byArray[1] || (by = this.wordBbuf.get()) != byArray[2] || (by = this.wordBbuf.get()) != byArray[3]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.archive.position(l3);
        }
        return bl;
    }

    private void skipBytes(int n) {
        long l = this.archive.position();
        long l2 = l + (long)n;
        if (l2 > this.archive.size()) {
            throw new EOFException();
        }
        this.archive.position(l2);
    }

    private void resolveLocalFileHeaderData(Map<ZipArchiveEntry, ZipFile$NameAndComment> map) {
        for (ZipArchiveEntry zipArchiveEntry : this.entries) {
            LinkedList<ZipArchiveEntry> linkedList;
            Object object;
            ZipFile$Entry zipFile$Entry = (ZipFile$Entry)zipArchiveEntry;
            long l = zipFile$Entry.getLocalHeaderOffset();
            this.archive.position(l + 26L);
            this.wordBbuf.rewind();
            IOUtils.readFully(this.archive, this.wordBbuf);
            this.wordBbuf.flip();
            this.wordBbuf.get(this.shortBuf);
            int n = ZipShort.getValue(this.shortBuf);
            this.wordBbuf.get(this.shortBuf);
            int n2 = ZipShort.getValue(this.shortBuf);
            this.skipBytes(n);
            byte[] byArray = new byte[n2];
            IOUtils.readFully(this.archive, ByteBuffer.wrap(byArray));
            zipFile$Entry.setExtra(byArray);
            zipFile$Entry.setDataOffset(l + 26L + 2L + 2L + (long)n + (long)n2);
            zipFile$Entry.setStreamContiguous(true);
            if (map.containsKey(zipFile$Entry)) {
                object = map.get(zipFile$Entry);
                ZipUtil.setNameAndCommentFromExtraFields(zipFile$Entry, ZipFile$NameAndComment.access$100((ZipFile$NameAndComment)object), ZipFile$NameAndComment.access$200((ZipFile$NameAndComment)object));
            }
            if ((linkedList = this.nameMap.get(object = zipFile$Entry.getName())) == null) {
                linkedList = new LinkedList();
                this.nameMap.put((String)object, linkedList);
            }
            linkedList.addLast(zipFile$Entry);
        }
    }

    private boolean startsWithLocalFileHeader() {
        this.archive.position(0L);
        this.wordBbuf.rewind();
        IOUtils.readFully(this.archive, this.wordBbuf);
        return Arrays.equals(this.wordBuf, ZipArchiveOutputStream.LFH_SIG);
    }

    private ZipFile$BoundedInputStream createBoundedInputStream(long l, long l2) {
        return this.archive instanceof FileChannel ? new ZipFile$BoundedFileChannelInputStream(this, l, l2) : new ZipFile$BoundedInputStream(this, l, l2);
    }

    static /* synthetic */ SeekableByteChannel access$300(ZipFile zipFile) {
        return zipFile.archive;
    }
}

