/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Serializable;
import org.apache.commons.compress.utils.ByteUtils;

public final class ZipShort
implements Serializable,
Cloneable {
    public static final ZipShort ZERO = new ZipShort(0);
    private static final long serialVersionUID = 1L;
    private final int value;

    public ZipShort(int n) {
        this.value = n;
    }

    public ZipShort(byte[] byArray) {
        this(byArray, 0);
    }

    public ZipShort(byte[] byArray, int n) {
        this.value = ZipShort.getValue(byArray, n);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[2];
        ByteUtils.toLittleEndian(byArray, this.value, 0, 2);
        return byArray;
    }

    public int getValue() {
        return this.value;
    }

    public static byte[] getBytes(int n) {
        byte[] byArray = new byte[2];
        ZipShort.putShort(n, byArray, 0);
        return byArray;
    }

    public static void putShort(int n, byte[] byArray, int n2) {
        ByteUtils.toLittleEndian(byArray, n, n2, 2);
    }

    public static int getValue(byte[] byArray, int n) {
        return (int)ByteUtils.fromLittleEndian(byArray, n, 2);
    }

    public static int getValue(byte[] byArray) {
        return ZipShort.getValue(byArray, 0);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)object).getValue();
    }

    public int hashCode() {
        return this.value;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public String toString() {
        return "ZipShort value: " + this.value;
    }
}

