/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory$1;
import org.apache.commons.compress.compressors.CompressorStreamFactory$2;
import org.apache.commons.compress.compressors.CompressorStreamProvider;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import org.apache.commons.compress.compressors.brotli.BrotliUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorOutputStream;
import org.apache.commons.compress.compressors.lzma.LZMAUtils;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.ServiceLoaderIterator;
import org.apache.commons.compress.utils.Sets;

public class CompressorStreamFactory
implements CompressorStreamProvider {
    private static final CompressorStreamFactory SINGLETON = new CompressorStreamFactory();
    public static final String BROTLI = "br";
    public static final String BZIP2 = "bzip2";
    public static final String GZIP = "gz";
    public static final String PACK200 = "pack200";
    public static final String XZ = "xz";
    public static final String LZMA = "lzma";
    public static final String SNAPPY_FRAMED = "snappy-framed";
    public static final String SNAPPY_RAW = "snappy-raw";
    public static final String Z = "z";
    public static final String DEFLATE = "deflate";
    public static final String DEFLATE64 = "deflate64";
    public static final String LZ4_BLOCK = "lz4-block";
    public static final String LZ4_FRAMED = "lz4-framed";
    public static final String ZSTANDARD = "zstd";
    private static final String YOU_NEED_BROTLI_DEC = CompressorStreamFactory.youNeed("Google Brotli Dec", "https://github.com/google/brotli/");
    private static final String YOU_NEED_XZ_JAVA = CompressorStreamFactory.youNeed("XZ for Java", "https://tukaani.org/xz/java.html");
    private static final String YOU_NEED_ZSTD_JNI = CompressorStreamFactory.youNeed("Zstd JNI", "https://github.com/luben/zstd-jni");
    private final Boolean decompressUntilEOF;
    private SortedMap<String, CompressorStreamProvider> compressorInputStreamProviders;
    private SortedMap<String, CompressorStreamProvider> compressorOutputStreamProviders;
    private volatile boolean decompressConcatenated = false;
    private final int memoryLimitInKb;

    private static String youNeed(String string, String string2) {
        return " In addition to Apache Commons Compress you need the " + string + " library - see " + string2;
    }

    public static SortedMap<String, CompressorStreamProvider> findAvailableCompressorInputStreamProviders() {
        return AccessController.doPrivileged(new CompressorStreamFactory$1());
    }

    public static SortedMap<String, CompressorStreamProvider> findAvailableCompressorOutputStreamProviders() {
        return AccessController.doPrivileged(new CompressorStreamFactory$2());
    }

    private static ArrayList<CompressorStreamProvider> findCompressorStreamProviders() {
        return Lists.newArrayList(CompressorStreamFactory.serviceLoaderIterator());
    }

    public static String getBrotli() {
        return BROTLI;
    }

    public static String getBzip2() {
        return BZIP2;
    }

    public static String getDeflate() {
        return DEFLATE;
    }

    public static String getDeflate64() {
        return DEFLATE64;
    }

    public static String getGzip() {
        return GZIP;
    }

    public static String getLzma() {
        return LZMA;
    }

    public static String getPack200() {
        return PACK200;
    }

    public static CompressorStreamFactory getSingleton() {
        return SINGLETON;
    }

    public static String getSnappyFramed() {
        return SNAPPY_FRAMED;
    }

    public static String getSnappyRaw() {
        return SNAPPY_RAW;
    }

    public static String getXz() {
        return XZ;
    }

    public static String getZ() {
        return Z;
    }

    public static String getLZ4Framed() {
        return LZ4_FRAMED;
    }

    public static String getLZ4Block() {
        return LZ4_BLOCK;
    }

    public static String getZstandard() {
        return ZSTANDARD;
    }

    static void putAll(Set<String> set, CompressorStreamProvider compressorStreamProvider, TreeMap<String, CompressorStreamProvider> treeMap) {
        for (String string : set) {
            treeMap.put(CompressorStreamFactory.toKey(string), compressorStreamProvider);
        }
    }

    private static Iterator<CompressorStreamProvider> serviceLoaderIterator() {
        return new ServiceLoaderIterator<CompressorStreamProvider>(CompressorStreamProvider.class);
    }

    private static String toKey(String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    public CompressorStreamFactory() {
        this.decompressUntilEOF = null;
        this.memoryLimitInKb = -1;
    }

    public CompressorStreamFactory(boolean bl, int n) {
        this.decompressUntilEOF = bl;
        this.decompressConcatenated = bl;
        this.memoryLimitInKb = n;
    }

    public CompressorStreamFactory(boolean bl) {
        this(bl, -1);
    }

    public static String detect(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Stream must not be null.");
        }
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Mark is not supported.");
        }
        byte[] byArray = new byte[12];
        inputStream.mark(byArray.length);
        int n = -1;
        try {
            n = IOUtils.readFully(inputStream, byArray);
            inputStream.reset();
        }
        catch (IOException iOException) {
            throw new CompressorException("IOException while reading signature.", iOException);
        }
        if (BZip2CompressorInputStream.matches(byArray, n)) {
            return BZIP2;
        }
        if (GzipCompressorInputStream.matches(byArray, n)) {
            return GZIP;
        }
        if (Pack200CompressorInputStream.matches(byArray, n)) {
            return PACK200;
        }
        if (FramedSnappyCompressorInputStream.matches(byArray, n)) {
            return SNAPPY_FRAMED;
        }
        if (ZCompressorInputStream.matches(byArray, n)) {
            return Z;
        }
        if (DeflateCompressorInputStream.matches(byArray, n)) {
            return DEFLATE;
        }
        if (XZUtils.matches(byArray, n)) {
            return XZ;
        }
        if (LZMAUtils.matches(byArray, n)) {
            return LZMA;
        }
        if (FramedLZ4CompressorInputStream.matches(byArray, n)) {
            return LZ4_FRAMED;
        }
        if (ZstdUtils.matches(byArray, n)) {
            return ZSTANDARD;
        }
        throw new CompressorException("No Compressor found for the stream signature.");
    }

    public CompressorInputStream createCompressorInputStream(InputStream inputStream) {
        return this.createCompressorInputStream(CompressorStreamFactory.detect(inputStream), inputStream);
    }

    public CompressorInputStream createCompressorInputStream(String string, InputStream inputStream) {
        return this.createCompressorInputStream(string, inputStream, this.decompressConcatenated);
    }

    @Override
    public CompressorInputStream createCompressorInputStream(String string, InputStream inputStream, boolean bl) {
        if (string == null || inputStream == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        try {
            if (GZIP.equalsIgnoreCase(string)) {
                return new GzipCompressorInputStream(inputStream, bl);
            }
            if (BZIP2.equalsIgnoreCase(string)) {
                return new BZip2CompressorInputStream(inputStream, bl);
            }
            if (BROTLI.equalsIgnoreCase(string)) {
                if (!BrotliUtils.isBrotliCompressionAvailable()) {
                    throw new CompressorException("Brotli compression is not available." + YOU_NEED_BROTLI_DEC);
                }
                return new BrotliCompressorInputStream(inputStream);
            }
            if (XZ.equalsIgnoreCase(string)) {
                if (!XZUtils.isXZCompressionAvailable()) {
                    throw new CompressorException("XZ compression is not available." + YOU_NEED_XZ_JAVA);
                }
                return new XZCompressorInputStream(inputStream, bl, this.memoryLimitInKb);
            }
            if (ZSTANDARD.equalsIgnoreCase(string)) {
                if (!ZstdUtils.isZstdCompressionAvailable()) {
                    throw new CompressorException("Zstandard compression is not available." + YOU_NEED_ZSTD_JNI);
                }
                return new ZstdCompressorInputStream(inputStream);
            }
            if (LZMA.equalsIgnoreCase(string)) {
                if (!LZMAUtils.isLZMACompressionAvailable()) {
                    throw new CompressorException("LZMA compression is not available" + YOU_NEED_XZ_JAVA);
                }
                return new LZMACompressorInputStream(inputStream, this.memoryLimitInKb);
            }
            if (PACK200.equalsIgnoreCase(string)) {
                return new Pack200CompressorInputStream(inputStream);
            }
            if (SNAPPY_RAW.equalsIgnoreCase(string)) {
                return new SnappyCompressorInputStream(inputStream);
            }
            if (SNAPPY_FRAMED.equalsIgnoreCase(string)) {
                return new FramedSnappyCompressorInputStream(inputStream);
            }
            if (Z.equalsIgnoreCase(string)) {
                return new ZCompressorInputStream(inputStream, this.memoryLimitInKb);
            }
            if (DEFLATE.equalsIgnoreCase(string)) {
                return new DeflateCompressorInputStream(inputStream);
            }
            if (DEFLATE64.equalsIgnoreCase(string)) {
                return new Deflate64CompressorInputStream(inputStream);
            }
            if (LZ4_BLOCK.equalsIgnoreCase(string)) {
                return new BlockLZ4CompressorInputStream(inputStream);
            }
            if (LZ4_FRAMED.equalsIgnoreCase(string)) {
                return new FramedLZ4CompressorInputStream(inputStream, bl);
            }
        }
        catch (IOException iOException) {
            throw new CompressorException("Could not create CompressorInputStream.", iOException);
        }
        CompressorStreamProvider compressorStreamProvider = (CompressorStreamProvider)this.getCompressorInputStreamProviders().get(CompressorStreamFactory.toKey(string));
        if (compressorStreamProvider != null) {
            return compressorStreamProvider.createCompressorInputStream(string, inputStream, bl);
        }
        throw new CompressorException("Compressor: " + string + " not found.");
    }

    @Override
    public CompressorOutputStream createCompressorOutputStream(String string, OutputStream outputStream) {
        if (string == null || outputStream == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        try {
            if (GZIP.equalsIgnoreCase(string)) {
                return new GzipCompressorOutputStream(outputStream);
            }
            if (BZIP2.equalsIgnoreCase(string)) {
                return new BZip2CompressorOutputStream(outputStream);
            }
            if (XZ.equalsIgnoreCase(string)) {
                return new XZCompressorOutputStream(outputStream);
            }
            if (PACK200.equalsIgnoreCase(string)) {
                return new Pack200CompressorOutputStream(outputStream);
            }
            if (LZMA.equalsIgnoreCase(string)) {
                return new LZMACompressorOutputStream(outputStream);
            }
            if (DEFLATE.equalsIgnoreCase(string)) {
                return new DeflateCompressorOutputStream(outputStream);
            }
            if (SNAPPY_FRAMED.equalsIgnoreCase(string)) {
                return new FramedSnappyCompressorOutputStream(outputStream);
            }
            if (LZ4_BLOCK.equalsIgnoreCase(string)) {
                return new BlockLZ4CompressorOutputStream(outputStream);
            }
            if (LZ4_FRAMED.equalsIgnoreCase(string)) {
                return new FramedLZ4CompressorOutputStream(outputStream);
            }
            if (ZSTANDARD.equalsIgnoreCase(string)) {
                return new ZstdCompressorOutputStream(outputStream);
            }
        }
        catch (IOException iOException) {
            throw new CompressorException("Could not create CompressorOutputStream", iOException);
        }
        CompressorStreamProvider compressorStreamProvider = (CompressorStreamProvider)this.getCompressorOutputStreamProviders().get(CompressorStreamFactory.toKey(string));
        if (compressorStreamProvider != null) {
            return compressorStreamProvider.createCompressorOutputStream(string, outputStream);
        }
        throw new CompressorException("Compressor: " + string + " not found.");
    }

    public SortedMap<String, CompressorStreamProvider> getCompressorInputStreamProviders() {
        if (this.compressorInputStreamProviders == null) {
            this.compressorInputStreamProviders = Collections.unmodifiableSortedMap(CompressorStreamFactory.findAvailableCompressorInputStreamProviders());
        }
        return this.compressorInputStreamProviders;
    }

    public SortedMap<String, CompressorStreamProvider> getCompressorOutputStreamProviders() {
        if (this.compressorOutputStreamProviders == null) {
            this.compressorOutputStreamProviders = Collections.unmodifiableSortedMap(CompressorStreamFactory.findAvailableCompressorOutputStreamProviders());
        }
        return this.compressorOutputStreamProviders;
    }

    boolean getDecompressConcatenated() {
        return this.decompressConcatenated;
    }

    public Boolean getDecompressUntilEOF() {
        return this.decompressUntilEOF;
    }

    @Override
    public Set<String> getInputStreamCompressorNames() {
        return Sets.newHashSet(GZIP, BROTLI, BZIP2, XZ, LZMA, PACK200, DEFLATE, SNAPPY_RAW, SNAPPY_FRAMED, Z, LZ4_BLOCK, LZ4_FRAMED, ZSTANDARD, DEFLATE64);
    }

    @Override
    public Set<String> getOutputStreamCompressorNames() {
        return Sets.newHashSet(GZIP, BZIP2, XZ, LZMA, PACK200, DEFLATE, SNAPPY_FRAMED, LZ4_BLOCK, LZ4_FRAMED, ZSTANDARD);
    }

    @Deprecated
    public void setDecompressConcatenated(boolean bl) {
        if (this.decompressUntilEOF != null) {
            throw new IllegalStateException("Cannot override the setting defined by the constructor");
        }
        this.decompressConcatenated = bl;
    }

    static /* synthetic */ CompressorStreamFactory access$000() {
        return SINGLETON;
    }

    static /* synthetic */ ArrayList access$100() {
        return CompressorStreamFactory.findCompressorStreamProviders();
    }
}

