/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.brotli;

import org.apache.commons.compress.compressors.brotli.BrotliUtils$CachedAvailability;

public class BrotliUtils {
    private static volatile BrotliUtils$CachedAvailability cachedBrotliAvailability = BrotliUtils$CachedAvailability.DONT_CACHE;

    private BrotliUtils() {
    }

    public static boolean isBrotliCompressionAvailable() {
        BrotliUtils$CachedAvailability brotliUtils$CachedAvailability = cachedBrotliAvailability;
        if (brotliUtils$CachedAvailability != BrotliUtils$CachedAvailability.DONT_CACHE) {
            return brotliUtils$CachedAvailability == BrotliUtils$CachedAvailability.CACHED_AVAILABLE;
        }
        return BrotliUtils.internalIsBrotliCompressionAvailable();
    }

    private static boolean internalIsBrotliCompressionAvailable() {
        try {
            Class.forName("org.brotli.dec.BrotliInputStream");
            return true;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            return false;
        }
    }

    public static void setCacheBrotliAvailablity(boolean bl) {
        if (!bl) {
            cachedBrotliAvailability = BrotliUtils$CachedAvailability.DONT_CACHE;
        } else if (cachedBrotliAvailability == BrotliUtils$CachedAvailability.DONT_CACHE) {
            boolean bl2 = BrotliUtils.internalIsBrotliCompressionAvailable();
            cachedBrotliAvailability = bl2 ? BrotliUtils$CachedAvailability.CACHED_AVAILABLE : BrotliUtils$CachedAvailability.CACHED_UNAVAILABLE;
        }
    }

    static BrotliUtils$CachedAvailability getCachedBrotliAvailability() {
        return cachedBrotliAvailability;
    }

    static {
        try {
            Class.forName("org.osgi.framework.BundleEvent");
        }
        catch (Exception exception) {
            BrotliUtils.setCacheBrotliAvailablity(true);
        }
    }
}

