/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream$Data;
import org.apache.commons.compress.compressors.bzip2.BZip2Constants;
import org.apache.commons.compress.compressors.bzip2.CRC;
import org.apache.commons.compress.compressors.bzip2.Rand;
import org.apache.commons.compress.utils.BitInputStream;
import org.apache.commons.compress.utils.CloseShieldFilterInputStream;
import org.apache.commons.compress.utils.InputStreamStatistics;

public class BZip2CompressorInputStream
extends CompressorInputStream
implements BZip2Constants,
InputStreamStatistics {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private final CRC crc = new CRC();
    private int nInUse;
    private BitInputStream bin;
    private final boolean decompressConcatenated;
    private static final int EOF = 0;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int su_count;
    private int su_ch2;
    private int su_chPrev;
    private int su_i2;
    private int su_j2;
    private int su_rNToGo;
    private int su_rTPos;
    private int su_tPos;
    private char su_z;
    private BZip2CompressorInputStream$Data data;

    public BZip2CompressorInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public BZip2CompressorInputStream(InputStream inputStream, boolean bl) {
        this.bin = new BitInputStream(inputStream == System.in ? new CloseShieldFilterInputStream(inputStream) : inputStream, ByteOrder.BIG_ENDIAN);
        this.decompressConcatenated = bl;
        this.init(true);
        this.initBlock();
    }

    @Override
    public int read() {
        if (this.bin != null) {
            int n = this.read0();
            this.count(n < 0 ? -1 : 1);
            return n;
        }
        throw new IOException("stream closed");
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        if (n < 0) {
            throw new IndexOutOfBoundsException("offs(" + n + ") < 0.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len(" + n2 + ") < 0.");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("offs(" + n + ") + len(" + n2 + ") > dest.length(" + byArray.length + ").");
        }
        if (this.bin == null) {
            throw new IOException("stream closed");
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4 && (n3 = this.read0()) >= 0) {
            byArray[n5++] = (byte)n3;
            this.count(1);
        }
        return n5 == n ? -1 : n5 - n;
    }

    @Override
    public long getCompressedCount() {
        return this.bin.getBytesRead();
    }

    private void makeMaps() {
        boolean[] blArray = this.data.inUse;
        byte[] byArray = this.data.seqToUnseq;
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (!blArray[i]) continue;
            byArray[n++] = (byte)i;
        }
        this.nInUse = n;
    }

    private int read0() {
        switch (this.currentState) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.setupBlock();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 3: {
                return this.setupRandPartB();
            }
            case 4: {
                return this.setupRandPartC();
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 6: {
                return this.setupNoRandPartB();
            }
            case 7: {
                return this.setupNoRandPartC();
            }
        }
        throw new IllegalStateException();
    }

    private int readNextByte(BitInputStream bitInputStream) {
        long l = bitInputStream.readBits(8);
        return (int)l;
    }

    private boolean init(boolean bl) {
        int n;
        if (null == this.bin) {
            throw new IOException("No InputStream");
        }
        if (!bl) {
            this.bin.clearBitCache();
        }
        if ((n = this.readNextByte(this.bin)) == -1 && !bl) {
            return false;
        }
        int n2 = this.readNextByte(this.bin);
        int n3 = this.readNextByte(this.bin);
        if (n != 66 || n2 != 90 || n3 != 104) {
            throw new IOException(bl ? "Stream is not in the BZip2 format" : "Garbage after a valid BZip2 stream");
        }
        int n4 = this.readNextByte(this.bin);
        if (n4 < 49 || n4 > 57) {
            throw new IOException("BZip2 block size is invalid");
        }
        this.blockSize100k = n4 - 48;
        this.computedCombinedCRC = 0;
        return true;
    }

    private void initBlock() {
        char c2;
        char c3;
        char c4;
        char c5;
        char c6;
        char c7;
        BitInputStream bitInputStream;
        block3: {
            bitInputStream = this.bin;
            do {
                c7 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c6 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c5 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c4 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c3 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c2 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                if (c7 != '\u0017' || c6 != 'r' || c5 != 'E' || c4 != '8' || c3 != 'P' || c2 != '\u0090') break block3;
            } while (!this.complete());
            return;
        }
        if (c7 != '1' || c6 != 'A' || c5 != 'Y' || c4 != '&' || c3 != 'S' || c2 != 'Y') {
            this.currentState = 0;
            throw new IOException("bad block header");
        }
        this.storedBlockCRC = BZip2CompressorInputStream.bsGetInt(bitInputStream);
        boolean bl = this.blockRandomised = BZip2CompressorInputStream.bsR(bitInputStream, 1) == 1;
        if (this.data == null) {
            this.data = new BZip2CompressorInputStream$Data(this.blockSize100k);
        }
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            this.computedCombinedCRC = this.storedCombinedCRC << 1 | this.storedCombinedCRC >>> 31;
            this.computedCombinedCRC ^= this.storedBlockCRC;
            throw new IOException("BZip2 CRC error");
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private boolean complete() {
        this.storedCombinedCRC = BZip2CompressorInputStream.bsGetInt(this.bin);
        this.currentState = 0;
        this.data = null;
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            throw new IOException("BZip2 CRC error");
        }
        return !this.decompressConcatenated || !this.init(false);
    }

    @Override
    public void close() {
        BitInputStream bitInputStream = this.bin;
        if (bitInputStream != null) {
            try {
                bitInputStream.close();
            }
            finally {
                this.data = null;
                this.bin = null;
            }
        }
    }

    private static int bsR(BitInputStream bitInputStream, int n) {
        long l = bitInputStream.readBits(n);
        if (l < 0L) {
            throw new IOException("unexpected end of stream");
        }
        return (int)l;
    }

    private static boolean bsGetBit(BitInputStream bitInputStream) {
        return BZip2CompressorInputStream.bsR(bitInputStream, 1) != 0;
    }

    private static char bsGetUByte(BitInputStream bitInputStream) {
        return (char)BZip2CompressorInputStream.bsR(bitInputStream, 8);
    }

    private static int bsGetInt(BitInputStream bitInputStream) {
        return BZip2CompressorInputStream.bsR(bitInputStream, 32);
    }

    private static void checkBounds(int n, int n2, String string) {
        if (n < 0) {
            throw new IOException("Corrupted input, " + string + " value negative");
        }
        if (n >= n2) {
            throw new IOException("Corrupted input, " + string + " value too big");
        }
    }

    private static void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = n; n5 <= n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                if (cArray[n4] != n5) continue;
                nArray3[n6++] = n4;
            }
        }
        n5 = 23;
        while (--n5 > 0) {
            nArray2[n5] = 0;
            nArray[n5] = 0;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            n6 = cArray[n5];
            BZip2CompressorInputStream.checkBounds(n6, 258, "length");
            int n7 = n6 + 1;
            nArray2[n7] = nArray2[n7] + 1;
        }
        n6 = nArray2[0];
        for (n5 = 1; n5 < 23; ++n5) {
            nArray2[n5] = n6 += nArray2[n5];
        }
        n6 = 0;
        n4 = nArray2[n5];
        for (n5 = n; n5 <= n2; ++n5) {
            int n8 = nArray2[n5 + 1];
            n4 = n8;
            nArray[n5] = (n6 += n8 - n4) - 1;
            n6 <<= 1;
        }
        for (n5 = n + 1; n5 <= n2; ++n5) {
            nArray2[n5] = (nArray[n5 - 1] + 1 << 1) - nArray2[n5];
        }
    }

    private void recvDecodingTables() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        BitInputStream bitInputStream = this.bin;
        BZip2CompressorInputStream$Data bZip2CompressorInputStream$Data = this.data;
        boolean[] blArray = bZip2CompressorInputStream$Data.inUse;
        byte[] byArray = bZip2CompressorInputStream$Data.recvDecodingTables_pos;
        byte[] byArray2 = bZip2CompressorInputStream$Data.selector;
        byte[] byArray3 = bZip2CompressorInputStream$Data.selectorMtf;
        int n7 = 0;
        for (n6 = 0; n6 < 16; ++n6) {
            if (!BZip2CompressorInputStream.bsGetBit(bitInputStream)) continue;
            n7 |= 1 << n6;
        }
        Arrays.fill(blArray, false);
        for (n6 = 0; n6 < 16; ++n6) {
            if ((n7 & 1 << n6) == 0) continue;
            n5 = n6 << 4;
            for (n4 = 0; n4 < 16; ++n4) {
                if (!BZip2CompressorInputStream.bsGetBit(bitInputStream)) continue;
                blArray[n5 + n4] = true;
            }
        }
        this.makeMaps();
        n6 = this.nInUse + 2;
        n5 = BZip2CompressorInputStream.bsR(bitInputStream, 3);
        n4 = BZip2CompressorInputStream.bsR(bitInputStream, 15);
        BZip2CompressorInputStream.checkBounds(n6, 259, "alphaSize");
        BZip2CompressorInputStream.checkBounds(n5, 7, "nGroups");
        BZip2CompressorInputStream.checkBounds(n4, 18003, "nSelectors");
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 0;
            while (BZip2CompressorInputStream.bsGetBit(bitInputStream)) {
                ++n2;
            }
            byArray3[n3] = (byte)n2;
        }
        n3 = n5;
        while (--n3 >= 0) {
            byArray[n3] = (byte)n3;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            BZip2CompressorInputStream.checkBounds(n2, 6, "selectorMtf");
            n = byArray[n2];
            for (n2 = byArray3[n3] & 0xFF; n2 > 0; --n2) {
                byArray[n2] = byArray[n2 - 1];
            }
            byArray[0] = n;
            byArray2[n3] = n;
        }
        char[][] cArray = bZip2CompressorInputStream$Data.temp_charArray2d;
        for (n2 = 0; n2 < n5; ++n2) {
            n = BZip2CompressorInputStream.bsR(bitInputStream, 5);
            char[] cArray2 = cArray[n2];
            for (int i = 0; i < n6; ++i) {
                while (BZip2CompressorInputStream.bsGetBit(bitInputStream)) {
                    n += BZip2CompressorInputStream.bsGetBit(bitInputStream) ? -1 : 1;
                }
                cArray2[i] = (char)n;
            }
        }
        this.createHuffmanDecodingTables(n6, n5);
    }

    private void createHuffmanDecodingTables(int n, int n2) {
        BZip2CompressorInputStream$Data bZip2CompressorInputStream$Data = this.data;
        char[][] cArray = bZip2CompressorInputStream$Data.temp_charArray2d;
        int[] nArray = bZip2CompressorInputStream$Data.minLens;
        int[][] nArray2 = bZip2CompressorInputStream$Data.limit;
        int[][] nArray3 = bZip2CompressorInputStream$Data.base;
        int[][] nArray4 = bZip2CompressorInputStream$Data.perm;
        for (int i = 0; i < n2; ++i) {
            int n3 = 32;
            int n4 = 0;
            char[] cArray2 = cArray[i];
            int n5 = n;
            while (--n5 >= 0) {
                int n6 = cArray2[n5];
                if (n6 > n4) {
                    n4 = n6;
                }
                if (n6 >= n3) continue;
                n3 = n6;
            }
            BZip2CompressorInputStream.hbCreateDecodeTables(nArray2[i], nArray3[i], nArray4[i], cArray[i], n3, n4, n);
            nArray[i] = n3;
        }
    }

    private void getAndMoveToFrontDecode() {
        BitInputStream bitInputStream = this.bin;
        this.origPtr = BZip2CompressorInputStream.bsR(bitInputStream, 24);
        this.recvDecodingTables();
        BZip2CompressorInputStream$Data bZip2CompressorInputStream$Data = this.data;
        byte[] byArray = bZip2CompressorInputStream$Data.ll8;
        int[] nArray = bZip2CompressorInputStream$Data.unzftab;
        byte[] byArray2 = bZip2CompressorInputStream$Data.selector;
        byte[] byArray3 = bZip2CompressorInputStream$Data.seqToUnseq;
        char[] cArray = bZip2CompressorInputStream$Data.getAndMoveToFrontDecode_yy;
        int[] nArray2 = bZip2CompressorInputStream$Data.minLens;
        int[][] nArray3 = bZip2CompressorInputStream$Data.limit;
        int[][] nArray4 = bZip2CompressorInputStream$Data.base;
        int[][] nArray5 = bZip2CompressorInputStream$Data.perm;
        int n = this.blockSize100k * 100000;
        int n2 = 256;
        while (--n2 >= 0) {
            cArray[n2] = (char)n2;
            nArray[n2] = 0;
        }
        n2 = 0;
        int n3 = 49;
        int n4 = this.nInUse + 1;
        int n5 = this.getAndMoveToFrontDecode0();
        int n6 = -1;
        int n7 = byArray2[n2] & 0xFF;
        BZip2CompressorInputStream.checkBounds(n7, 6, "zt");
        int[] nArray6 = nArray4[n7];
        int[] nArray7 = nArray3[n7];
        int[] nArray8 = nArray5[n7];
        int n8 = nArray2[n7];
        while (n5 != n4) {
            int n9;
            int n10;
            int n11;
            int n12;
            if (n5 == 0 || n5 == 1) {
                n12 = -1;
                n11 = 1;
                while (true) {
                    if (n5 == 0) {
                        n12 += n11;
                    } else {
                        if (n5 != 1) break;
                        n12 += n11 << 1;
                    }
                    if (n3 == 0) {
                        n3 = 49;
                        BZip2CompressorInputStream.checkBounds(++n2, 18002, "groupNo");
                        n7 = byArray2[n2] & 0xFF;
                        BZip2CompressorInputStream.checkBounds(n7, 6, "zt");
                        nArray6 = nArray4[n7];
                        nArray7 = nArray3[n7];
                        nArray8 = nArray5[n7];
                        n8 = nArray2[n7];
                    } else {
                        --n3;
                    }
                    n10 = n8;
                    BZip2CompressorInputStream.checkBounds(n10, 258, "zn");
                    n9 = BZip2CompressorInputStream.bsR(bitInputStream, n10);
                    while (n9 > nArray7[n10]) {
                        BZip2CompressorInputStream.checkBounds(++n10, 258, "zn");
                        n9 = n9 << 1 | BZip2CompressorInputStream.bsR(bitInputStream, 1);
                    }
                    int n13 = n9 - nArray6[n10];
                    BZip2CompressorInputStream.checkBounds(n13, 258, "zvec");
                    n5 = nArray8[n13];
                    n11 <<= 1;
                }
                n11 = cArray[0];
                BZip2CompressorInputStream.checkBounds(n11, 256, "yy");
                n10 = byArray3[n11];
                int n14 = n10 & 0xFF;
                nArray[n14] = nArray[n14] + (n12 + 1);
                n9 = ++n6;
                Arrays.fill(byArray, n9, (n6 += n12) + 1, (byte)n10);
                if (n6 < n) continue;
                throw new IOException("block overrun while expanding RLE in MTF, " + n6 + " exceeds " + n);
            }
            if (++n6 >= n) {
                throw new IOException("block overrun in MTF, " + n6 + " exceeds " + n);
            }
            BZip2CompressorInputStream.checkBounds(n5, 257, "nextSym");
            n12 = cArray[n5 - 1];
            BZip2CompressorInputStream.checkBounds(n12, 256, "yy");
            int n15 = byArray3[n12] & 0xFF;
            nArray[n15] = nArray[n15] + 1;
            byArray[n6] = byArray3[n12];
            if (n5 <= 16) {
                n11 = n5 - 1;
                while (n11 > 0) {
                    cArray[n11--] = cArray[n11];
                }
            } else {
                System.arraycopy(cArray, 0, cArray, 1, n5 - 1);
            }
            cArray[0] = n12;
            if (n3 == 0) {
                n3 = 49;
                BZip2CompressorInputStream.checkBounds(++n2, 18002, "groupNo");
                n7 = byArray2[n2] & 0xFF;
                BZip2CompressorInputStream.checkBounds(n7, 6, "zt");
                nArray6 = nArray4[n7];
                nArray7 = nArray3[n7];
                nArray8 = nArray5[n7];
                n8 = nArray2[n7];
            } else {
                --n3;
            }
            n11 = n8;
            BZip2CompressorInputStream.checkBounds(n11, 258, "zn");
            n10 = BZip2CompressorInputStream.bsR(bitInputStream, n11);
            while (n10 > nArray7[n11]) {
                BZip2CompressorInputStream.checkBounds(++n11, 258, "zn");
                n10 = n10 << 1 | BZip2CompressorInputStream.bsR(bitInputStream, 1);
            }
            n9 = n10 - nArray6[n11];
            BZip2CompressorInputStream.checkBounds(n9, 258, "zvec");
            n5 = nArray8[n9];
        }
        this.last = n6;
    }

    private int getAndMoveToFrontDecode0() {
        BZip2CompressorInputStream$Data bZip2CompressorInputStream$Data = this.data;
        int n = bZip2CompressorInputStream$Data.selector[0] & 0xFF;
        BZip2CompressorInputStream.checkBounds(n, 6, "zt");
        int[] nArray = bZip2CompressorInputStream$Data.limit[n];
        int n2 = bZip2CompressorInputStream$Data.minLens[n];
        BZip2CompressorInputStream.checkBounds(n2, 258, "zn");
        int n3 = BZip2CompressorInputStream.bsR(this.bin, n2);
        while (n3 > nArray[n2]) {
            BZip2CompressorInputStream.checkBounds(++n2, 258, "zn");
            n3 = n3 << 1 | BZip2CompressorInputStream.bsR(this.bin, 1);
        }
        int n4 = n3 - bZip2CompressorInputStream$Data.base[n][n2];
        BZip2CompressorInputStream.checkBounds(n4, 258, "zvec");
        return bZip2CompressorInputStream$Data.perm[n][n4];
    }

    private int setupBlock() {
        int n;
        if (this.currentState == 0 || this.data == null) {
            return -1;
        }
        int[] nArray = this.data.cftab;
        int n2 = this.last + 1;
        int[] nArray2 = this.data.initTT(n2);
        byte[] byArray = this.data.ll8;
        nArray[0] = 0;
        System.arraycopy(this.data.unzftab, 0, nArray, 1, 256);
        int n3 = nArray[0];
        for (n = 1; n <= 256; ++n) {
            nArray[n] = n3 += nArray[n];
        }
        n = 0;
        n3 = this.last;
        while (n <= n3) {
            int n4;
            int n5 = byArray[n] & 0xFF;
            nArray[n5] = nArray[n5] + 1;
            BZip2CompressorInputStream.checkBounds(n4, n2, "tt index");
            nArray2[n4] = n++;
        }
        if (this.origPtr < 0 || this.origPtr >= nArray2.length) {
            throw new IOException("stream corrupted");
        }
        this.su_tPos = nArray2[this.origPtr];
        this.su_count = 0;
        this.su_i2 = 0;
        this.su_ch2 = 256;
        if (this.blockRandomised) {
            this.su_rNToGo = 0;
            this.su_rTPos = 0;
            return this.setupRandPartA();
        }
        return this.setupNoRandPartA();
    }

    private int setupRandPartA() {
        if (this.su_i2 <= this.last) {
            this.su_chPrev = this.su_ch2;
            int n = this.data.ll8[this.su_tPos] & 0xFF;
            BZip2CompressorInputStream.checkBounds(this.su_tPos, this.data.tt.length, "su_tPos");
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_ch2 = n ^= this.su_rNToGo == 1 ? 1 : 0;
            ++this.su_i2;
            this.currentState = 3;
            this.crc.updateCRC(n);
            return n;
        }
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupNoRandPartA() {
        if (this.su_i2 <= this.last) {
            int n;
            this.su_chPrev = this.su_ch2;
            this.su_ch2 = n = this.data.ll8[this.su_tPos] & 0xFF;
            BZip2CompressorInputStream.checkBounds(this.su_tPos, this.data.tt.length, "su_tPos");
            this.su_tPos = this.data.tt[this.su_tPos];
            ++this.su_i2;
            this.currentState = 6;
            this.crc.updateCRC(n);
            return n;
        }
        this.currentState = 5;
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupRandPartB() {
        if (this.su_ch2 != this.su_chPrev) {
            this.currentState = 2;
            this.su_count = 1;
            return this.setupRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            BZip2CompressorInputStream.checkBounds(this.su_tPos, this.data.tt.length, "su_tPos");
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_j2 = 0;
            this.currentState = 4;
            if (this.su_rNToGo == 1) {
                this.su_z = (char)(this.su_z ^ '\u0001');
            }
            return this.setupRandPartC();
        }
        this.currentState = 2;
        return this.setupRandPartA();
    }

    private int setupRandPartC() {
        if (this.su_j2 < this.su_z) {
            this.crc.updateCRC(this.su_ch2);
            ++this.su_j2;
            return this.su_ch2;
        }
        this.currentState = 2;
        ++this.su_i2;
        this.su_count = 0;
        return this.setupRandPartA();
    }

    private int setupNoRandPartB() {
        if (this.su_ch2 != this.su_chPrev) {
            this.su_count = 1;
            return this.setupNoRandPartA();
        }
        if (++this.su_count >= 4) {
            BZip2CompressorInputStream.checkBounds(this.su_tPos, this.data.ll8.length, "su_tPos");
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            this.su_j2 = 0;
            return this.setupNoRandPartC();
        }
        return this.setupNoRandPartA();
    }

    private int setupNoRandPartC() {
        if (this.su_j2 < this.su_z) {
            int n = this.su_ch2;
            this.crc.updateCRC(n);
            ++this.su_j2;
            this.currentState = 7;
            return n;
        }
        ++this.su_i2;
        this.su_count = 0;
        return this.setupNoRandPartA();
    }

    public static boolean matches(byte[] byArray, int n) {
        return n >= 3 && byArray[0] == 66 && byArray[1] == 90 && byArray[2] == 104;
    }
}

