/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate64;

import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;

public class Deflate64CompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private InputStream originalStream;
    private HuffmanDecoder decoder;
    private long compressedBytesRead;
    private final byte[] oneByte = new byte[1];

    public Deflate64CompressorInputStream(InputStream inputStream) {
        this(new HuffmanDecoder(inputStream));
        this.originalStream = inputStream;
    }

    Deflate64CompressorInputStream(HuffmanDecoder huffmanDecoder) {
        this.decoder = huffmanDecoder;
    }

    @Override
    public int read() {
        int n;
        block5: while (true) {
            n = this.read(this.oneByte);
            switch (n) {
                case 1: {
                    return this.oneByte[0] & 0xFF;
                }
                case -1: {
                    return -1;
                }
                case 0: {
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid return value from read: " + n);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = -1;
        if (this.decoder != null) {
            n3 = this.decoder.decode(byArray, n, n2);
            this.compressedBytesRead = this.decoder.getBytesRead();
            this.count(n3);
            if (n3 == -1) {
                this.closeDecoder();
            }
        }
        return n3;
    }

    @Override
    public int available() {
        return this.decoder != null ? this.decoder.available() : 0;
    }

    @Override
    public void close() {
        this.closeDecoder();
        if (this.originalStream != null) {
            this.originalStream.close();
            this.originalStream = null;
        }
    }

    @Override
    public long getCompressedCount() {
        return this.compressedBytesRead;
    }

    private void closeDecoder() {
        IOUtils.closeQuietly(this.decoder);
        this.decoder = null;
    }
}

