/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream$State;
import org.apache.commons.compress.compressors.lz77support.AbstractLZ77CompressorInputStream;
import org.apache.commons.compress.utils.ByteUtils;

public class BlockLZ4CompressorInputStream
extends AbstractLZ77CompressorInputStream {
    static final int WINDOW_SIZE = 65536;
    static final int SIZE_BITS = 4;
    static final int BACK_REFERENCE_SIZE_MASK = 15;
    static final int LITERAL_SIZE_MASK = 240;
    private int nextBackReferenceSize;
    private BlockLZ4CompressorInputStream$State state = BlockLZ4CompressorInputStream$State.NO_BLOCK;

    public BlockLZ4CompressorInputStream(InputStream inputStream) {
        super(inputStream, 65536);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        switch (this.state) {
            case EOF: {
                return -1;
            }
            case NO_BLOCK: {
                this.readSizes();
            }
            case IN_LITERAL: {
                int n3 = this.readLiteral(byArray, n, n2);
                if (!this.hasMoreDataInBlock()) {
                    this.state = BlockLZ4CompressorInputStream$State.LOOKING_FOR_BACK_REFERENCE;
                }
                return n3 > 0 ? n3 : this.read(byArray, n, n2);
            }
            case LOOKING_FOR_BACK_REFERENCE: {
                if (!this.initializeBackReference()) {
                    this.state = BlockLZ4CompressorInputStream$State.EOF;
                    return -1;
                }
            }
            case IN_BACK_REFERENCE: {
                int n4 = this.readBackReference(byArray, n, n2);
                if (!this.hasMoreDataInBlock()) {
                    this.state = BlockLZ4CompressorInputStream$State.NO_BLOCK;
                }
                return n4 > 0 ? n4 : this.read(byArray, n, n2);
            }
        }
        throw new IOException("Unknown stream state " + (Object)((Object)this.state));
    }

    private void readSizes() {
        int n = this.readOneByte();
        if (n == -1) {
            throw new IOException("Premature end of stream while looking for next block");
        }
        this.nextBackReferenceSize = n & 0xF;
        long l = (n & 0xF0) >> 4;
        if (l == 15L) {
            l += this.readSizeBytes();
        }
        this.startLiteral(l);
        this.state = BlockLZ4CompressorInputStream$State.IN_LITERAL;
    }

    private long readSizeBytes() {
        int n;
        long l = 0L;
        do {
            if ((n = this.readOneByte()) == -1) {
                throw new IOException("Premature end of stream while parsing length");
            }
            l += (long)n;
        } while (n == 255);
        return l;
    }

    private boolean initializeBackReference() {
        int n = 0;
        try {
            n = (int)ByteUtils.fromLittleEndian(this.supplier, 2);
        }
        catch (IOException iOException) {
            if (this.nextBackReferenceSize == 0) {
                return false;
            }
            throw iOException;
        }
        long l = this.nextBackReferenceSize;
        if (this.nextBackReferenceSize == 15) {
            l += this.readSizeBytes();
        }
        this.startBackReference(n, l + 4L);
        this.state = BlockLZ4CompressorInputStream$State.IN_BACK_REFERENCE;
        return true;
    }
}

