/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream$1;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream$Pair;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$BackReference;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$LiteralBlock;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.compressors.lz77support.Parameters$Builder;

public class BlockLZ4CompressorOutputStream
extends CompressorOutputStream {
    private static final int MIN_BACK_REFERENCE_LENGTH = 4;
    private static final int MIN_OFFSET_OF_LAST_BACK_REFERENCE = 12;
    private final LZ77Compressor compressor;
    private final OutputStream os;
    private final byte[] oneByte = new byte[1];
    private boolean finished = false;
    private Deque<BlockLZ4CompressorOutputStream$Pair> pairs = new LinkedList<BlockLZ4CompressorOutputStream$Pair>();
    private Deque<byte[]> expandedBlocks = new LinkedList<byte[]>();

    public BlockLZ4CompressorOutputStream(OutputStream outputStream) {
        this(outputStream, BlockLZ4CompressorOutputStream.createParameterBuilder().build());
    }

    public BlockLZ4CompressorOutputStream(OutputStream outputStream, Parameters parameters) {
        this.os = outputStream;
        this.compressor = new LZ77Compressor(parameters, new BlockLZ4CompressorOutputStream$1(this));
    }

    @Override
    public void write(int n) {
        this.oneByte[0] = (byte)(n & 0xFF);
        this.write(this.oneByte);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.compressor.compress(byArray, n, n2);
    }

    @Override
    public void close() {
        this.finish();
        this.os.close();
    }

    public void finish() {
        if (!this.finished) {
            this.compressor.finish();
            this.finished = true;
        }
    }

    public void prefill(byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n, n + n2);
            this.compressor.prefill(byArray2);
            this.recordLiteral(byArray2);
        }
    }

    private void addLiteralBlock(LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock) {
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair = this.writeBlocksAndReturnUnfinishedPair(lZ77Compressor$LiteralBlock.getLength());
        this.recordLiteral(blockLZ4CompressorOutputStream$Pair.addLiteral(lZ77Compressor$LiteralBlock));
        this.clearUnusedBlocksAndPairs();
    }

    private void addBackReference(LZ77Compressor$BackReference lZ77Compressor$BackReference) {
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair = this.writeBlocksAndReturnUnfinishedPair(lZ77Compressor$BackReference.getLength());
        blockLZ4CompressorOutputStream$Pair.setBackReference(lZ77Compressor$BackReference);
        this.recordBackReference(lZ77Compressor$BackReference);
        this.clearUnusedBlocksAndPairs();
    }

    private BlockLZ4CompressorOutputStream$Pair writeBlocksAndReturnUnfinishedPair(int n) {
        this.writeWritablePairs(n);
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair = this.pairs.peekLast();
        if (blockLZ4CompressorOutputStream$Pair == null || blockLZ4CompressorOutputStream$Pair.hasBackReference()) {
            blockLZ4CompressorOutputStream$Pair = new BlockLZ4CompressorOutputStream$Pair();
            this.pairs.addLast(blockLZ4CompressorOutputStream$Pair);
        }
        return blockLZ4CompressorOutputStream$Pair;
    }

    private void recordLiteral(byte[] byArray) {
        this.expandedBlocks.addFirst(byArray);
    }

    private void clearUnusedBlocksAndPairs() {
        this.clearUnusedBlocks();
        this.clearUnusedPairs();
    }

    private void clearUnusedBlocks() {
        int n = 0;
        int n2 = 0;
        for (byte[] byArray : this.expandedBlocks) {
            ++n2;
            if ((n += byArray.length) < 65536) continue;
            break;
        }
        int n3 = this.expandedBlocks.size();
        for (int i = n2; i < n3; ++i) {
            this.expandedBlocks.removeLast();
        }
    }

    private void recordBackReference(LZ77Compressor$BackReference lZ77Compressor$BackReference) {
        this.expandedBlocks.addFirst(this.expand(lZ77Compressor$BackReference.getOffset(), lZ77Compressor$BackReference.getLength()));
    }

    private byte[] expand(int n, int n2) {
        byte[] byArray = new byte[n2];
        if (n == 1) {
            byte[] byArray2 = this.expandedBlocks.peekFirst();
            byte by = byArray2[byArray2.length - 1];
            if (by != 0) {
                Arrays.fill(byArray, by);
            }
        } else {
            this.expandFromList(byArray, n, n2);
        }
        return byArray;
    }

    private void expandFromList(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        while (n4 > 0) {
            int n6;
            int n7;
            byte[] byArray2 = null;
            if (n3 > 0) {
                int n8 = 0;
                for (byte[] byArray3 : this.expandedBlocks) {
                    if (byArray3.length + n8 >= n3) {
                        byArray2 = byArray3;
                        break;
                    }
                    n8 += byArray3.length;
                }
                if (byArray2 == null) {
                    throw new IllegalStateException("failed to find a block containing offset " + n);
                }
                n7 = n8 + byArray2.length - n3;
                n6 = Math.min(n4, byArray2.length - n7);
            } else {
                byArray2 = byArray;
                n7 = -n3;
                n6 = Math.min(n4, n5 + n3);
            }
            System.arraycopy(byArray2, n7, byArray, n5, n6);
            n3 -= n6;
            n4 -= n6;
            n5 += n6;
        }
    }

    private void clearUnusedPairs() {
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair;
        int n = 0;
        int n2 = 0;
        Iterator<BlockLZ4CompressorOutputStream$Pair> iterator = this.pairs.descendingIterator();
        while (iterator.hasNext()) {
            BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair2 = iterator.next();
            ++n2;
            if ((n += blockLZ4CompressorOutputStream$Pair2.length()) < 65536) continue;
            break;
        }
        int n3 = this.pairs.size();
        for (int i = n2; i < n3 && BlockLZ4CompressorOutputStream$Pair.access$300(blockLZ4CompressorOutputStream$Pair = this.pairs.peekFirst()); ++i) {
            this.pairs.removeFirst();
        }
    }

    private void writeFinalLiteralBlock() {
        this.rewriteLastPairs();
        for (BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair : this.pairs) {
            if (BlockLZ4CompressorOutputStream$Pair.access$300(blockLZ4CompressorOutputStream$Pair)) continue;
            blockLZ4CompressorOutputStream$Pair.writeTo(this.os);
        }
        this.pairs.clear();
    }

    private void writeWritablePairs(int n) {
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair2;
        int n2 = n;
        Iterator<BlockLZ4CompressorOutputStream$Pair> iterator = this.pairs.descendingIterator();
        while (iterator.hasNext() && !BlockLZ4CompressorOutputStream$Pair.access$300(blockLZ4CompressorOutputStream$Pair2 = iterator.next())) {
            n2 += blockLZ4CompressorOutputStream$Pair2.length();
        }
        for (BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair2 : this.pairs) {
            if (BlockLZ4CompressorOutputStream$Pair.access$300(blockLZ4CompressorOutputStream$Pair2)) continue;
            if (!blockLZ4CompressorOutputStream$Pair2.canBeWritten(n2 -= blockLZ4CompressorOutputStream$Pair2.length())) break;
            blockLZ4CompressorOutputStream$Pair2.writeTo(this.os);
        }
    }

    private void rewriteLastPairs() {
        int n;
        int n2;
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair2;
        LinkedList<BlockLZ4CompressorOutputStream$Pair> linkedList = new LinkedList<BlockLZ4CompressorOutputStream$Pair>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        int n3 = 0;
        Iterator<BlockLZ4CompressorOutputStream$Pair> iterator = this.pairs.descendingIterator();
        while (iterator.hasNext() && !BlockLZ4CompressorOutputStream$Pair.access$300(blockLZ4CompressorOutputStream$Pair2 = iterator.next())) {
            n2 = blockLZ4CompressorOutputStream$Pair2.length();
            linkedList2.addFirst(n2);
            linkedList.addFirst(blockLZ4CompressorOutputStream$Pair2);
            if ((n3 += n2) < 12) continue;
            break;
        }
        for (BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair2 : linkedList) {
            this.pairs.remove(blockLZ4CompressorOutputStream$Pair2);
        }
        int n4 = linkedList.size();
        int n5 = 0;
        for (n2 = 1; n2 < n4; ++n2) {
            n5 += ((Integer)linkedList2.get(n2)).intValue();
        }
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair3 = new BlockLZ4CompressorOutputStream$Pair();
        if (n5 > 0) {
            BlockLZ4CompressorOutputStream$Pair.access$400(blockLZ4CompressorOutputStream$Pair3, this.expand(n5, n5));
        }
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair4 = (BlockLZ4CompressorOutputStream$Pair)linkedList.get(0);
        int n6 = 12 - n5;
        int n7 = n = blockLZ4CompressorOutputStream$Pair4.hasBackReference() ? BlockLZ4CompressorOutputStream$Pair.access$500(blockLZ4CompressorOutputStream$Pair4) : 0;
        if (blockLZ4CompressorOutputStream$Pair4.hasBackReference() && n >= 4 + n6) {
            BlockLZ4CompressorOutputStream$Pair.access$400(blockLZ4CompressorOutputStream$Pair3, this.expand(n5 + n6, n6));
            this.pairs.add(BlockLZ4CompressorOutputStream$Pair.access$600(blockLZ4CompressorOutputStream$Pair4, n - n6));
        } else {
            if (blockLZ4CompressorOutputStream$Pair4.hasBackReference()) {
                BlockLZ4CompressorOutputStream$Pair.access$400(blockLZ4CompressorOutputStream$Pair3, this.expand(n5 + n, n));
            }
            BlockLZ4CompressorOutputStream$Pair.access$700(blockLZ4CompressorOutputStream$Pair4, blockLZ4CompressorOutputStream$Pair3);
        }
        this.pairs.add(blockLZ4CompressorOutputStream$Pair3);
    }

    public static Parameters$Builder createParameterBuilder() {
        int n = 65535;
        return Parameters.builder(65536).withMinBackReferenceLength(4).withMaxBackReferenceLength(n).withMaxOffset(n).withMaxLiteralLength(n);
    }

    static /* synthetic */ void access$000(BlockLZ4CompressorOutputStream blockLZ4CompressorOutputStream, LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock) {
        blockLZ4CompressorOutputStream.addLiteralBlock(lZ77Compressor$LiteralBlock);
    }

    static /* synthetic */ void access$100(BlockLZ4CompressorOutputStream blockLZ4CompressorOutputStream, LZ77Compressor$BackReference lZ77Compressor$BackReference) {
        blockLZ4CompressorOutputStream.addBackReference(lZ77Compressor$BackReference);
    }

    static /* synthetic */ void access$200(BlockLZ4CompressorOutputStream blockLZ4CompressorOutputStream) {
        blockLZ4CompressorOutputStream.writeFinalLiteralBlock();
    }
}

