/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream$1;
import org.apache.commons.compress.compressors.lz4.XXHash32;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.ByteUtils$ByteSupplier;
import org.apache.commons.compress.utils.ChecksumCalculatingInputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;

public class FramedLZ4CompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    static final byte[] LZ4_SIGNATURE = new byte[]{4, 34, 77, 24};
    private static final byte[] SKIPPABLE_FRAME_TRAILER = new byte[]{42, 77, 24};
    private static final byte SKIPPABLE_FRAME_PREFIX_BYTE_MASK = 80;
    static final int VERSION_MASK = 192;
    static final int SUPPORTED_VERSION = 64;
    static final int BLOCK_INDEPENDENCE_MASK = 32;
    static final int BLOCK_CHECKSUM_MASK = 16;
    static final int CONTENT_SIZE_MASK = 8;
    static final int CONTENT_CHECKSUM_MASK = 4;
    static final int BLOCK_MAX_SIZE_MASK = 112;
    static final int UNCOMPRESSED_FLAG_MASK = Integer.MIN_VALUE;
    private final byte[] oneByte = new byte[1];
    private final ByteUtils$ByteSupplier supplier = new FramedLZ4CompressorInputStream$1(this);
    private final CountingInputStream in;
    private final boolean decompressConcatenated;
    private boolean expectBlockChecksum;
    private boolean expectBlockDependency;
    private boolean expectContentSize;
    private boolean expectContentChecksum;
    private InputStream currentBlock;
    private boolean endReached;
    private boolean inUncompressed;
    private final XXHash32 contentHash = new XXHash32();
    private final XXHash32 blockHash = new XXHash32();
    private byte[] blockDependencyBuffer;

    public FramedLZ4CompressorInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public FramedLZ4CompressorInputStream(InputStream inputStream, boolean bl) {
        this.in = new CountingInputStream(inputStream);
        this.decompressConcatenated = bl;
        this.init(true);
    }

    @Override
    public int read() {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public void close() {
        if (this.currentBlock != null) {
            this.currentBlock.close();
            this.currentBlock = null;
        }
        this.in.close();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this.endReached) {
            return -1;
        }
        int n3 = this.readOnce(byArray, n, n2);
        if (n3 == -1) {
            this.nextBlock();
            if (!this.endReached) {
                n3 = this.readOnce(byArray, n, n2);
            }
        }
        if (n3 != -1) {
            if (this.expectBlockDependency) {
                this.appendToBlockDependencyBuffer(byArray, n, n3);
            }
            if (this.expectContentChecksum) {
                this.contentHash.update(byArray, n, n3);
            }
        }
        return n3;
    }

    @Override
    public long getCompressedCount() {
        return this.in.getBytesRead();
    }

    private void init(boolean bl) {
        if (this.readSignature(bl)) {
            this.readFrameDescriptor();
            this.nextBlock();
        }
    }

    private boolean readSignature(boolean bl) {
        String string = bl ? "Not a LZ4 frame stream" : "LZ4 frame stream followed by garbage";
        byte[] byArray = new byte[4];
        int n = IOUtils.readFully(this.in, byArray);
        this.count(n);
        if (0 == n && !bl) {
            this.endReached = true;
            return false;
        }
        if (4 != n) {
            throw new IOException(string);
        }
        n = this.skipSkippableFrame(byArray);
        if (0 == n && !bl) {
            this.endReached = true;
            return false;
        }
        if (4 != n || !FramedLZ4CompressorInputStream.matches(byArray, 4)) {
            throw new IOException(string);
        }
        return true;
    }

    private void readFrameDescriptor() {
        int n;
        int n2;
        int n3 = this.readOneByte();
        if (n3 == -1) {
            throw new IOException("Premature end of stream while reading frame flags");
        }
        this.contentHash.update(n3);
        if ((n3 & 0xC0) != 64) {
            throw new IOException("Unsupported version " + (n3 >> 6));
        }
        boolean bl = this.expectBlockDependency = (n3 & 0x20) == 0;
        if (this.expectBlockDependency) {
            if (this.blockDependencyBuffer == null) {
                this.blockDependencyBuffer = new byte[65536];
            }
        } else {
            this.blockDependencyBuffer = null;
        }
        this.expectBlockChecksum = (n3 & 0x10) != 0;
        this.expectContentSize = (n3 & 8) != 0;
        this.expectContentChecksum = (n3 & 4) != 0;
        int n4 = this.readOneByte();
        if (n4 == -1) {
            throw new IOException("Premature end of stream while reading frame BD byte");
        }
        this.contentHash.update(n4);
        if (this.expectContentSize) {
            byte[] byArray = new byte[8];
            n2 = IOUtils.readFully(this.in, byArray);
            this.count(n2);
            if (8 != n2) {
                throw new IOException("Premature end of stream while reading content size");
            }
            this.contentHash.update(byArray, 0, byArray.length);
        }
        if ((n = this.readOneByte()) == -1) {
            throw new IOException("Premature end of stream while reading frame header checksum");
        }
        n2 = (int)(this.contentHash.getValue() >> 8 & 0xFFL);
        this.contentHash.reset();
        if (n != n2) {
            throw new IOException("frame header checksum mismatch.");
        }
    }

    private void nextBlock() {
        this.maybeFinishCurrentBlock();
        long l = ByteUtils.fromLittleEndian(this.supplier, 4);
        boolean bl = (l & Integer.MIN_VALUE) != 0L;
        int n = (int)(l & Integer.MAX_VALUE);
        if (n == 0) {
            this.verifyContentChecksum();
            if (!this.decompressConcatenated) {
                this.endReached = true;
            } else {
                this.init(false);
            }
            return;
        }
        InputStream inputStream = new BoundedInputStream(this.in, n);
        if (this.expectBlockChecksum) {
            inputStream = new ChecksumCalculatingInputStream(this.blockHash, inputStream);
        }
        if (bl) {
            this.inUncompressed = true;
            this.currentBlock = inputStream;
        } else {
            this.inUncompressed = false;
            BlockLZ4CompressorInputStream blockLZ4CompressorInputStream = new BlockLZ4CompressorInputStream(inputStream);
            if (this.expectBlockDependency) {
                blockLZ4CompressorInputStream.prefill(this.blockDependencyBuffer);
            }
            this.currentBlock = blockLZ4CompressorInputStream;
        }
    }

    private void maybeFinishCurrentBlock() {
        if (this.currentBlock != null) {
            this.currentBlock.close();
            this.currentBlock = null;
            if (this.expectBlockChecksum) {
                this.verifyChecksum(this.blockHash, "block");
                this.blockHash.reset();
            }
        }
    }

    private void verifyContentChecksum() {
        if (this.expectContentChecksum) {
            this.verifyChecksum(this.contentHash, "content");
        }
        this.contentHash.reset();
    }

    private void verifyChecksum(XXHash32 xXHash32, String string) {
        byte[] byArray = new byte[4];
        int n = IOUtils.readFully(this.in, byArray);
        this.count(n);
        if (4 != n) {
            throw new IOException("Premature end of stream while reading " + string + " checksum");
        }
        long l = xXHash32.getValue();
        if (l != ByteUtils.fromLittleEndian(byArray)) {
            throw new IOException(string + " checksum mismatch.");
        }
    }

    private int readOneByte() {
        int n = this.in.read();
        if (n != -1) {
            this.count(1);
            return n & 0xFF;
        }
        return -1;
    }

    private int readOnce(byte[] byArray, int n, int n2) {
        if (this.inUncompressed) {
            int n3 = this.currentBlock.read(byArray, n, n2);
            this.count(n3);
            return n3;
        }
        BlockLZ4CompressorInputStream blockLZ4CompressorInputStream = (BlockLZ4CompressorInputStream)this.currentBlock;
        long l = blockLZ4CompressorInputStream.getBytesRead();
        int n4 = this.currentBlock.read(byArray, n, n2);
        this.count(blockLZ4CompressorInputStream.getBytesRead() - l);
        return n4;
    }

    private static boolean isSkippableFrameSignature(byte[] byArray) {
        if ((byArray[0] & 0x50) != 80) {
            return false;
        }
        for (int i = 1; i < 4; ++i) {
            if (byArray[i] == SKIPPABLE_FRAME_TRAILER[i - 1]) continue;
            return false;
        }
        return true;
    }

    private int skipSkippableFrame(byte[] byArray) {
        int n = 4;
        while (n == 4 && FramedLZ4CompressorInputStream.isSkippableFrameSignature(byArray)) {
            long l = ByteUtils.fromLittleEndian(this.supplier, 4);
            long l2 = IOUtils.skip(this.in, l);
            this.count(l2);
            if (l != l2) {
                throw new IOException("Premature end of stream while skipping frame");
            }
            n = IOUtils.readFully(this.in, byArray);
            this.count(n);
        }
        return n;
    }

    private void appendToBlockDependencyBuffer(byte[] byArray, int n, int n2) {
        if ((n2 = Math.min(n2, this.blockDependencyBuffer.length)) > 0) {
            int n3 = this.blockDependencyBuffer.length - n2;
            if (n3 > 0) {
                System.arraycopy(this.blockDependencyBuffer, n2, this.blockDependencyBuffer, 0, n3);
            }
            System.arraycopy(byArray, n, this.blockDependencyBuffer, n3, n2);
        }
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < LZ4_SIGNATURE.length) {
            return false;
        }
        byte[] byArray2 = byArray;
        if (byArray.length > LZ4_SIGNATURE.length) {
            byArray2 = new byte[LZ4_SIGNATURE.length];
            System.arraycopy(byArray, 0, byArray2, 0, LZ4_SIGNATURE.length);
        }
        return Arrays.equals(byArray2, LZ4_SIGNATURE);
    }

    static /* synthetic */ int access$000(FramedLZ4CompressorInputStream framedLZ4CompressorInputStream) {
        return framedLZ4CompressorInputStream.readOneByte();
    }
}

