/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream$Parameters;
import org.apache.commons.compress.compressors.lz4.XXHash32;
import org.apache.commons.compress.utils.ByteUtils;

public class FramedLZ4CompressorOutputStream
extends CompressorOutputStream {
    private static final byte[] END_MARK = new byte[4];
    private final byte[] oneByte = new byte[1];
    private final byte[] blockData;
    private final OutputStream out;
    private final FramedLZ4CompressorOutputStream$Parameters params;
    private boolean finished = false;
    private int currentIndex = 0;
    private final XXHash32 contentHash = new XXHash32();
    private final XXHash32 blockHash;
    private byte[] blockDependencyBuffer;
    private int collectedBlockDependencyBytes;

    public FramedLZ4CompressorOutputStream(OutputStream outputStream) {
        this(outputStream, FramedLZ4CompressorOutputStream$Parameters.DEFAULT);
    }

    public FramedLZ4CompressorOutputStream(OutputStream outputStream, FramedLZ4CompressorOutputStream$Parameters framedLZ4CompressorOutputStream$Parameters) {
        this.params = framedLZ4CompressorOutputStream$Parameters;
        this.blockData = new byte[FramedLZ4CompressorOutputStream$Parameters.access$000(framedLZ4CompressorOutputStream$Parameters).getSize()];
        this.out = outputStream;
        this.blockHash = FramedLZ4CompressorOutputStream$Parameters.access$100(framedLZ4CompressorOutputStream$Parameters) ? new XXHash32() : null;
        outputStream.write(FramedLZ4CompressorInputStream.LZ4_SIGNATURE);
        this.writeFrameDescriptor();
        this.blockDependencyBuffer = FramedLZ4CompressorOutputStream$Parameters.access$200(framedLZ4CompressorOutputStream$Parameters) ? new byte[65536] : null;
    }

    @Override
    public void write(int n) {
        this.oneByte[0] = (byte)(n & 0xFF);
        this.write(this.oneByte);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (FramedLZ4CompressorOutputStream$Parameters.access$300(this.params)) {
            this.contentHash.update(byArray, n, n2);
        }
        if (this.currentIndex + n2 > this.blockData.length) {
            this.flushBlock();
            while (n2 > this.blockData.length) {
                System.arraycopy(byArray, n, this.blockData, 0, this.blockData.length);
                n += this.blockData.length;
                n2 -= this.blockData.length;
                this.currentIndex = this.blockData.length;
                this.flushBlock();
            }
        }
        System.arraycopy(byArray, n, this.blockData, this.currentIndex, n2);
        this.currentIndex += n2;
    }

    @Override
    public void close() {
        this.finish();
        this.out.close();
    }

    public void finish() {
        if (!this.finished) {
            if (this.currentIndex > 0) {
                this.flushBlock();
            }
            this.writeTrailer();
            this.finished = true;
        }
    }

    private void writeFrameDescriptor() {
        int n = 64;
        if (!FramedLZ4CompressorOutputStream$Parameters.access$200(this.params)) {
            n |= 0x20;
        }
        if (FramedLZ4CompressorOutputStream$Parameters.access$300(this.params)) {
            n |= 4;
        }
        if (FramedLZ4CompressorOutputStream$Parameters.access$100(this.params)) {
            n |= 0x10;
        }
        this.out.write(n);
        this.contentHash.update(n);
        int n2 = FramedLZ4CompressorOutputStream$Parameters.access$000(this.params).getIndex() << 4 & 0x70;
        this.out.write(n2);
        this.contentHash.update(n2);
        this.out.write((int)(this.contentHash.getValue() >> 8 & 0xFFL));
        this.contentHash.reset();
    }

    private void flushBlock() {
        boolean bl = FramedLZ4CompressorOutputStream$Parameters.access$200(this.params);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Object object = new BlockLZ4CompressorOutputStream(byteArrayOutputStream, FramedLZ4CompressorOutputStream$Parameters.access$400(this.params));){
            if (bl) {
                ((BlockLZ4CompressorOutputStream)object).prefill(this.blockDependencyBuffer, this.blockDependencyBuffer.length - this.collectedBlockDependencyBytes, this.collectedBlockDependencyBytes);
            }
            ((BlockLZ4CompressorOutputStream)object).write(this.blockData, 0, this.currentIndex);
        }
        if (bl) {
            this.appendToBlockDependencyBuffer(this.blockData, 0, this.currentIndex);
        }
        if (((Object)(object = (Object)byteArrayOutputStream.toByteArray())).length > this.currentIndex) {
            ByteUtils.toLittleEndian(this.out, (long)(this.currentIndex | Integer.MIN_VALUE), 4);
            this.out.write(this.blockData, 0, this.currentIndex);
            if (FramedLZ4CompressorOutputStream$Parameters.access$100(this.params)) {
                this.blockHash.update(this.blockData, 0, this.currentIndex);
            }
        } else {
            ByteUtils.toLittleEndian(this.out, (long)((Object)object).length, 4);
            this.out.write((byte[])object);
            if (FramedLZ4CompressorOutputStream$Parameters.access$100(this.params)) {
                this.blockHash.update((byte[])object, 0, ((Object)object).length);
            }
        }
        if (FramedLZ4CompressorOutputStream$Parameters.access$100(this.params)) {
            ByteUtils.toLittleEndian(this.out, this.blockHash.getValue(), 4);
            this.blockHash.reset();
        }
        this.currentIndex = 0;
    }

    private void writeTrailer() {
        this.out.write(END_MARK);
        if (FramedLZ4CompressorOutputStream$Parameters.access$300(this.params)) {
            ByteUtils.toLittleEndian(this.out, this.contentHash.getValue(), 4);
        }
    }

    private void appendToBlockDependencyBuffer(byte[] byArray, int n, int n2) {
        if ((n2 = Math.min(n2, this.blockDependencyBuffer.length)) > 0) {
            int n3 = this.blockDependencyBuffer.length - n2;
            if (n3 > 0) {
                System.arraycopy(this.blockDependencyBuffer, n2, this.blockDependencyBuffer, 0, n3);
            }
            System.arraycopy(byArray, n, this.blockDependencyBuffer, n3, n2);
            this.collectedBlockDependencyBytes = Math.min(this.collectedBlockDependencyBytes + n2, this.blockDependencyBuffer.length);
        }
    }
}

