/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import java.util.Arrays;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$BackReference;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$Block;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$Callback;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$EOD;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$LiteralBlock;
import org.apache.commons.compress.compressors.lz77support.Parameters;

public class LZ77Compressor {
    private static final LZ77Compressor$Block THE_EOD = new LZ77Compressor$EOD();
    static final int NUMBER_OF_BYTES_IN_HASH = 3;
    private static final int NO_MATCH = -1;
    private final Parameters params;
    private final LZ77Compressor$Callback callback;
    private final byte[] window;
    private final int[] head;
    private final int[] prev;
    private final int wMask;
    private boolean initialized = false;
    private int currentPosition;
    private int lookahead = 0;
    private int insertHash = 0;
    private int blockStart = 0;
    private int matchStart = -1;
    private int missedInserts = 0;
    private static final int HASH_SIZE = 32768;
    private static final int HASH_MASK = Short.MAX_VALUE;
    private static final int H_SHIFT = 5;

    public LZ77Compressor(Parameters parameters, LZ77Compressor$Callback lZ77Compressor$Callback) {
        if (parameters == null) {
            throw new NullPointerException("params must not be null");
        }
        if (lZ77Compressor$Callback == null) {
            throw new NullPointerException("callback must not be null");
        }
        this.params = parameters;
        this.callback = lZ77Compressor$Callback;
        int n = parameters.getWindowSize();
        this.window = new byte[n * 2];
        this.wMask = n - 1;
        this.head = new int[32768];
        Arrays.fill(this.head, -1);
        this.prev = new int[n];
    }

    public void compress(byte[] byArray) {
        this.compress(byArray, 0, byArray.length);
    }

    public void compress(byte[] byArray, int n, int n2) {
        int n3 = this.params.getWindowSize();
        while (n2 > n3) {
            this.doCompress(byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
        if (n2 > 0) {
            this.doCompress(byArray, n, n2);
        }
    }

    public void finish() {
        if (this.blockStart != this.currentPosition || this.lookahead > 0) {
            this.currentPosition += this.lookahead;
            this.flushLiteralBlock();
        }
        this.callback.accept(THE_EOD);
    }

    public void prefill(byte[] byArray) {
        if (this.currentPosition != 0 || this.lookahead != 0) {
            throw new IllegalStateException("the compressor has already started to accept data, can't prefill anymore");
        }
        int n = Math.min(this.params.getWindowSize(), byArray.length);
        System.arraycopy(byArray, byArray.length - n, this.window, 0, n);
        if (n >= 3) {
            this.initialize();
            int n2 = n - 3 + 1;
            for (int i = 0; i < n2; ++i) {
                this.insertString(i);
            }
            this.missedInserts = 2;
        } else {
            this.missedInserts = n;
        }
        this.blockStart = this.currentPosition = n;
    }

    private int nextHash(int n, byte by) {
        int n2 = by & 0xFF;
        return (n << 5 ^ n2) & Short.MAX_VALUE;
    }

    private void doCompress(byte[] byArray, int n, int n2) {
        int n3 = this.window.length - this.currentPosition - this.lookahead;
        if (n2 > n3) {
            this.slide();
        }
        System.arraycopy(byArray, n, this.window, this.currentPosition + this.lookahead, n2);
        this.lookahead += n2;
        if (!this.initialized && this.lookahead >= this.params.getMinBackReferenceLength()) {
            this.initialize();
        }
        if (this.initialized) {
            this.compress();
        }
    }

    private void slide() {
        int n;
        int n2;
        int n3 = this.params.getWindowSize();
        if (this.blockStart != this.currentPosition && this.blockStart < n3) {
            this.flushLiteralBlock();
            this.blockStart = this.currentPosition;
        }
        System.arraycopy(this.window, n3, this.window, 0, n3);
        this.currentPosition -= n3;
        this.matchStart -= n3;
        this.blockStart -= n3;
        for (n2 = 0; n2 < 32768; ++n2) {
            n = this.head[n2];
            this.head[n2] = n >= n3 ? n - n3 : -1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.prev[n2];
            this.prev[n2] = n >= n3 ? n - n3 : -1;
        }
    }

    private void initialize() {
        for (int i = 0; i < 2; ++i) {
            this.insertHash = this.nextHash(this.insertHash, this.window[i]);
        }
        this.initialized = true;
    }

    private void compress() {
        int n = this.params.getMinBackReferenceLength();
        boolean bl = this.params.getLazyMatching();
        int n2 = this.params.getLazyMatchingThreshold();
        while (this.lookahead >= n) {
            this.catchUpMissedInserts();
            int n3 = 0;
            int n4 = this.insertString(this.currentPosition);
            if (n4 != -1 && n4 - this.currentPosition <= this.params.getMaxOffset()) {
                n3 = this.longestMatch(n4);
                if (bl && n3 <= n2 && this.lookahead > n) {
                    n3 = this.longestMatchForNextPosition(n3);
                }
            }
            if (n3 >= n) {
                if (this.blockStart != this.currentPosition) {
                    this.flushLiteralBlock();
                    this.blockStart = -1;
                }
                this.flushBackReference(n3);
                this.insertStringsInMatch(n3);
                this.lookahead -= n3;
                this.currentPosition += n3;
                this.blockStart = this.currentPosition;
                continue;
            }
            --this.lookahead;
            ++this.currentPosition;
            if (this.currentPosition - this.blockStart < this.params.getMaxLiteralLength()) continue;
            this.flushLiteralBlock();
            this.blockStart = this.currentPosition;
        }
    }

    private int insertString(int n) {
        int n2;
        this.insertHash = this.nextHash(this.insertHash, this.window[n - 1 + 3]);
        this.prev[n & this.wMask] = n2 = this.head[this.insertHash];
        this.head[this.insertHash] = n;
        return n2;
    }

    private int longestMatchForNextPosition(int n) {
        int n2 = this.matchStart;
        int n3 = this.insertHash;
        --this.lookahead;
        ++this.currentPosition;
        int n4 = this.insertString(this.currentPosition);
        int n5 = this.prev[this.currentPosition & this.wMask];
        int n6 = this.longestMatch(n4);
        if (n6 <= n) {
            n6 = n;
            this.matchStart = n2;
            this.head[this.insertHash] = n5;
            this.insertHash = n3;
            --this.currentPosition;
            ++this.lookahead;
        }
        return n6;
    }

    private void insertStringsInMatch(int n) {
        int n2 = Math.min(n - 1, this.lookahead - 3);
        for (int i = 1; i <= n2; ++i) {
            this.insertString(this.currentPosition + i);
        }
        this.missedInserts = n - n2 - 1;
    }

    private void catchUpMissedInserts() {
        while (this.missedInserts > 0) {
            this.insertString(this.currentPosition - this.missedInserts--);
        }
    }

    private void flushBackReference(int n) {
        this.callback.accept(new LZ77Compressor$BackReference(this.currentPosition - this.matchStart, n));
    }

    private void flushLiteralBlock() {
        this.callback.accept(new LZ77Compressor$LiteralBlock(this.window, this.blockStart, this.currentPosition - this.blockStart));
    }

    private int longestMatch(int n) {
        int n2 = this.params.getMinBackReferenceLength();
        int n3 = n2 - 1;
        int n4 = Math.min(this.params.getMaxBackReferenceLength(), this.lookahead);
        int n5 = Math.max(0, this.currentPosition - this.params.getMaxOffset());
        int n6 = Math.min(n4, this.params.getNiceBackReferenceLength());
        int n7 = this.params.getMaxCandidates();
        for (int i = 0; i < n7 && n >= n5; ++i) {
            int n8 = 0;
            for (int j = 0; j < n4 && this.window[n + j] == this.window[this.currentPosition + j]; ++j) {
                ++n8;
            }
            if (n8 > n3) {
                n3 = n8;
                this.matchStart = n;
                if (n8 >= n6) break;
            }
            n = this.prev[n & this.wMask];
        }
        return n3;
    }
}

