/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.compressors.lz77support.Parameters$1;

public class Parameters$Builder {
    private final int windowSize;
    private int minBackReferenceLength;
    private int maxBackReferenceLength;
    private int maxOffset;
    private int maxLiteralLength;
    private Integer niceBackReferenceLength;
    private Integer maxCandidates;
    private Integer lazyThreshold;
    private Boolean lazyMatches;

    private Parameters$Builder(int n) {
        if (n < 2 || !Parameters.access$100(n)) {
            throw new IllegalArgumentException("windowSize must be a power of two");
        }
        this.windowSize = n;
        this.minBackReferenceLength = 3;
        this.maxBackReferenceLength = n - 1;
        this.maxOffset = n - 1;
        this.maxLiteralLength = n;
    }

    public Parameters$Builder withMinBackReferenceLength(int n) {
        this.minBackReferenceLength = Math.max(3, n);
        if (this.windowSize < this.minBackReferenceLength) {
            throw new IllegalArgumentException("minBackReferenceLength can't be bigger than windowSize");
        }
        if (this.maxBackReferenceLength < this.minBackReferenceLength) {
            this.maxBackReferenceLength = this.minBackReferenceLength;
        }
        return this;
    }

    public Parameters$Builder withMaxBackReferenceLength(int n) {
        this.maxBackReferenceLength = n < this.minBackReferenceLength ? this.minBackReferenceLength : Math.min(n, this.windowSize - 1);
        return this;
    }

    public Parameters$Builder withMaxOffset(int n) {
        this.maxOffset = n < 1 ? this.windowSize - 1 : Math.min(n, this.windowSize - 1);
        return this;
    }

    public Parameters$Builder withMaxLiteralLength(int n) {
        this.maxLiteralLength = n < 1 ? this.windowSize : Math.min(n, this.windowSize);
        return this;
    }

    public Parameters$Builder withNiceBackReferenceLength(int n) {
        this.niceBackReferenceLength = n;
        return this;
    }

    public Parameters$Builder withMaxNumberOfCandidates(int n) {
        this.maxCandidates = n;
        return this;
    }

    public Parameters$Builder withLazyMatching(boolean bl) {
        this.lazyMatches = bl;
        return this;
    }

    public Parameters$Builder withLazyThreshold(int n) {
        this.lazyThreshold = n;
        return this;
    }

    public Parameters$Builder tunedForSpeed() {
        this.niceBackReferenceLength = Math.max(this.minBackReferenceLength, this.maxBackReferenceLength / 8);
        this.maxCandidates = Math.max(32, this.windowSize / 1024);
        this.lazyMatches = false;
        this.lazyThreshold = this.minBackReferenceLength;
        return this;
    }

    public Parameters$Builder tunedForCompressionRatio() {
        this.niceBackReferenceLength = this.lazyThreshold = Integer.valueOf(this.maxBackReferenceLength);
        this.maxCandidates = Math.max(32, this.windowSize / 16);
        this.lazyMatches = true;
        return this;
    }

    public Parameters build() {
        boolean bl;
        int n = this.niceBackReferenceLength != null ? this.niceBackReferenceLength : Math.max(this.minBackReferenceLength, this.maxBackReferenceLength / 2);
        int n2 = this.maxCandidates != null ? this.maxCandidates : Math.max(256, this.windowSize / 128);
        boolean bl2 = bl = this.lazyMatches == null || this.lazyMatches != false;
        int n3 = bl ? (this.lazyThreshold != null ? this.lazyThreshold : n) : this.minBackReferenceLength;
        return new Parameters(this.windowSize, this.minBackReferenceLength, this.maxBackReferenceLength, this.maxOffset, this.maxLiteralLength, n, n2, bl, n3, null);
    }

    /* synthetic */ Parameters$Builder(int n, Parameters$1 parameters$1) {
        this(n);
    }
}

