/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lzma;

import java.io.InputStream;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.tukaani.xz.LZMAInputStream;

public class LZMACompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final InputStream in;

    public LZMACompressorInputStream(InputStream inputStream) {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = new LZMAInputStream((InputStream)this.countingStream, -1);
    }

    public LZMACompressorInputStream(InputStream inputStream, int n) {
        try {
            this.countingStream = new CountingInputStream(inputStream);
            this.in = new LZMAInputStream((InputStream)this.countingStream, n);
        }
        catch (org.tukaani.xz.MemoryLimitException memoryLimitException) {
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded(), memoryLimitException.getMemoryLimit(), (Exception)((Object)memoryLimitException));
        }
    }

    @Override
    public int read() {
        int n = this.in.read();
        this.count(n == -1 ? 0 : 1);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.in.read(byArray, n, n2);
        this.count(n3);
        return n3;
    }

    @Override
    public long skip(long l) {
        return IOUtils.skip(this.in, l);
    }

    @Override
    public int available() {
        return this.in.available();
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }

    public static boolean matches(byte[] byArray, int n) {
        return byArray != null && n >= 3 && byArray[0] == 93 && byArray[1] == 0 && byArray[2] == 0;
    }
}

