/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream$1;
import org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import org.apache.commons.compress.compressors.pack200.StreamBridge;
import org.apache.commons.compress.utils.IOUtils;

public class Pack200CompressorInputStream
extends CompressorInputStream {
    private final InputStream originalInput;
    private final StreamBridge streamBridge;
    private static final byte[] CAFE_DOOD = new byte[]{-54, -2, -48, 13};
    private static final int SIG_LENGTH = CAFE_DOOD.length;

    public Pack200CompressorInputStream(InputStream inputStream) {
        this(inputStream, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorInputStream(InputStream inputStream, Pack200Strategy pack200Strategy) {
        this(inputStream, null, pack200Strategy, null);
    }

    public Pack200CompressorInputStream(InputStream inputStream, Map<String, String> map) {
        this(inputStream, Pack200Strategy.IN_MEMORY, map);
    }

    public Pack200CompressorInputStream(InputStream inputStream, Pack200Strategy pack200Strategy, Map<String, String> map) {
        this(inputStream, null, pack200Strategy, map);
    }

    public Pack200CompressorInputStream(File file) {
        this(file, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorInputStream(File file, Pack200Strategy pack200Strategy) {
        this(null, file, pack200Strategy, null);
    }

    public Pack200CompressorInputStream(File file, Map<String, String> map) {
        this(file, Pack200Strategy.IN_MEMORY, map);
    }

    public Pack200CompressorInputStream(File file, Pack200Strategy pack200Strategy, Map<String, String> map) {
        this(null, file, pack200Strategy, map);
    }

    private Pack200CompressorInputStream(InputStream inputStream, File file, Pack200Strategy pack200Strategy, Map<String, String> map) {
        this.originalInput = inputStream;
        this.streamBridge = pack200Strategy.newStreamBridge();
        try (JarOutputStream jarOutputStream = new JarOutputStream(this.streamBridge);){
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            if (map != null) {
                unpacker.properties().putAll(map);
            }
            if (file == null) {
                unpacker.unpack((InputStream)new Pack200CompressorInputStream$1(this, inputStream), jarOutputStream);
            } else {
                unpacker.unpack(file, jarOutputStream);
            }
        }
    }

    @Override
    public int read() {
        return this.streamBridge.getInput().read();
    }

    @Override
    public int read(byte[] byArray) {
        return this.streamBridge.getInput().read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        return this.streamBridge.getInput().read(byArray, n, n2);
    }

    @Override
    public int available() {
        return this.streamBridge.getInput().available();
    }

    @Override
    public boolean markSupported() {
        try {
            return this.streamBridge.getInput().markSupported();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void mark(int n) {
        try {
            this.streamBridge.getInput().mark(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void reset() {
        this.streamBridge.getInput().reset();
    }

    @Override
    public long skip(long l) {
        return IOUtils.skip(this.streamBridge.getInput(), l);
    }

    @Override
    public void close() {
        try {
            this.streamBridge.stop();
        }
        finally {
            if (this.originalInput != null) {
                this.originalInput.close();
            }
        }
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < SIG_LENGTH) {
            return false;
        }
        for (int i = 0; i < SIG_LENGTH; ++i) {
            if (byArray[i] == CAFE_DOOD[i]) continue;
            return false;
        }
        return true;
    }
}

