/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Pack200Utils {
    private Pack200Utils() {
    }

    public static void normalize(File file) {
        Pack200Utils.normalize(file, file, null);
    }

    public static void normalize(File file, Map<String, String> map) {
        Pack200Utils.normalize(file, file, map);
    }

    public static void normalize(File file, File file2) {
        Pack200Utils.normalize(file, file2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalize(File file, File file2, Map<String, String> map) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("pack.segment.limit", "-1");
        File file3 = File.createTempFile("commons-compress", "pack200normalize");
        try {
            Object object;
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            Object object2 = null;
            try {
                object = new JarFile(file);
                Throwable throwable = null;
                try {
                    Pack200.Packer packer = Pack200.newPacker();
                    packer.properties().putAll(map);
                    packer.pack((JarFile)object, (OutputStream)fileOutputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((ZipFile)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((ZipFile)object).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (fileOutputStream != null) {
                    if (object2 != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        fileOutputStream.close();
                    }
                }
            }
            fileOutputStream = Pack200.newUnpacker();
            object2 = new JarOutputStream(new FileOutputStream(file2));
            object = null;
            try {
                fileOutputStream.unpack(file3, (JarOutputStream)object2);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((ZipOutputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((ZipOutputStream)object2).close();
                    }
                }
            }
        }
        finally {
            if (!file3.delete()) {
                file3.deleteOnExit();
            }
        }
    }
}

