/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.lz77support.AbstractLZ77CompressorInputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream$State;
import org.apache.commons.compress.utils.ByteUtils;

public class SnappyCompressorInputStream
extends AbstractLZ77CompressorInputStream {
    private static final int TAG_MASK = 3;
    public static final int DEFAULT_BLOCK_SIZE = 32768;
    private final int size;
    private int uncompressedBytesRemaining;
    private SnappyCompressorInputStream$State state = SnappyCompressorInputStream$State.NO_BLOCK;
    private boolean endReached = false;

    public SnappyCompressorInputStream(InputStream inputStream) {
        this(inputStream, 32768);
    }

    public SnappyCompressorInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
        this.uncompressedBytesRemaining = this.size = (int)this.readSize();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this.endReached) {
            return -1;
        }
        switch (this.state) {
            case NO_BLOCK: {
                this.fill();
                return this.read(byArray, n, n2);
            }
            case IN_LITERAL: {
                int n3 = this.readLiteral(byArray, n, n2);
                if (!this.hasMoreDataInBlock()) {
                    this.state = SnappyCompressorInputStream$State.NO_BLOCK;
                }
                return n3 > 0 ? n3 : this.read(byArray, n, n2);
            }
            case IN_BACK_REFERENCE: {
                int n4 = this.readBackReference(byArray, n, n2);
                if (!this.hasMoreDataInBlock()) {
                    this.state = SnappyCompressorInputStream$State.NO_BLOCK;
                }
                return n4 > 0 ? n4 : this.read(byArray, n, n2);
            }
        }
        throw new IOException("Unknown stream state " + (Object)((Object)this.state));
    }

    private void fill() {
        if (this.uncompressedBytesRemaining == 0) {
            this.endReached = true;
            return;
        }
        int n = this.readOneByte();
        if (n == -1) {
            throw new IOException("Premature end of stream reading block start");
        }
        int n2 = 0;
        int n3 = 0;
        switch (n & 3) {
            case 0: {
                n2 = this.readLiteralLength(n);
                this.uncompressedBytesRemaining -= n2;
                this.startLiteral(n2);
                this.state = SnappyCompressorInputStream$State.IN_LITERAL;
                break;
            }
            case 1: {
                n2 = 4 + (n >> 2 & 7);
                this.uncompressedBytesRemaining -= n2;
                n3 = (n & 0xE0) << 3;
                n = this.readOneByte();
                if (n == -1) {
                    throw new IOException("Premature end of stream reading back-reference length");
                }
                this.startBackReference(n3 |= n, n2);
                this.state = SnappyCompressorInputStream$State.IN_BACK_REFERENCE;
                break;
            }
            case 2: {
                n2 = (n >> 2) + 1;
                this.uncompressedBytesRemaining -= n2;
                n3 = (int)ByteUtils.fromLittleEndian(this.supplier, 2);
                this.startBackReference(n3, n2);
                this.state = SnappyCompressorInputStream$State.IN_BACK_REFERENCE;
                break;
            }
            case 3: {
                n2 = (n >> 2) + 1;
                this.uncompressedBytesRemaining -= n2;
                n3 = (int)ByteUtils.fromLittleEndian(this.supplier, 4) & Integer.MAX_VALUE;
                this.startBackReference(n3, n2);
                this.state = SnappyCompressorInputStream$State.IN_BACK_REFERENCE;
                break;
            }
        }
    }

    private int readLiteralLength(int n) {
        int n2;
        switch (n >> 2) {
            case 60: {
                n2 = this.readOneByte();
                if (n2 != -1) break;
                throw new IOException("Premature end of stream reading literal length");
            }
            case 61: {
                n2 = (int)ByteUtils.fromLittleEndian(this.supplier, 2);
                break;
            }
            case 62: {
                n2 = (int)ByteUtils.fromLittleEndian(this.supplier, 3);
                break;
            }
            case 63: {
                n2 = (int)ByteUtils.fromLittleEndian(this.supplier, 4);
                break;
            }
            default: {
                n2 = n >> 2;
            }
        }
        return n2 + 1;
    }

    private long readSize() {
        int n = 0;
        long l = 0L;
        int n2 = 0;
        do {
            if ((n2 = this.readOneByte()) == -1) {
                throw new IOException("Premature end of stream reading size");
            }
            l |= (long)((n2 & 0x7F) << n++ * 7);
        } while (0 != (n2 & 0x80));
        return l;
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

