/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$BackReference;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$LiteralBlock;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.compressors.lz77support.Parameters$Builder;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorOutputStream$1;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.ByteUtils$ByteConsumer;
import org.apache.commons.compress.utils.ByteUtils$OutputStreamByteConsumer;

public class SnappyCompressorOutputStream
extends CompressorOutputStream {
    private final LZ77Compressor compressor;
    private final OutputStream os;
    private final ByteUtils$ByteConsumer consumer;
    private final byte[] oneByte = new byte[1];
    private boolean finished = false;
    private static final int MAX_LITERAL_SIZE_WITHOUT_SIZE_BYTES = 60;
    private static final int MAX_LITERAL_SIZE_WITH_ONE_SIZE_BYTE = 256;
    private static final int MAX_LITERAL_SIZE_WITH_TWO_SIZE_BYTES = 65536;
    private static final int MAX_LITERAL_SIZE_WITH_THREE_SIZE_BYTES = 0x1000000;
    private static final int ONE_SIZE_BYTE_MARKER = 240;
    private static final int TWO_SIZE_BYTE_MARKER = 244;
    private static final int THREE_SIZE_BYTE_MARKER = 248;
    private static final int FOUR_SIZE_BYTE_MARKER = 252;
    private static final int MIN_MATCH_LENGTH_WITH_ONE_OFFSET_BYTE = 4;
    private static final int MAX_MATCH_LENGTH_WITH_ONE_OFFSET_BYTE = 11;
    private static final int MAX_OFFSET_WITH_ONE_OFFSET_BYTE = 1024;
    private static final int MAX_OFFSET_WITH_TWO_OFFSET_BYTES = 32768;
    private static final int ONE_BYTE_COPY_TAG = 1;
    private static final int TWO_BYTE_COPY_TAG = 2;
    private static final int FOUR_BYTE_COPY_TAG = 3;
    private static final int MIN_MATCH_LENGTH = 4;
    private static final int MAX_MATCH_LENGTH = 64;

    public SnappyCompressorOutputStream(OutputStream outputStream, long l) {
        this(outputStream, l, 32768);
    }

    public SnappyCompressorOutputStream(OutputStream outputStream, long l, int n) {
        this(outputStream, l, SnappyCompressorOutputStream.createParameterBuilder(n).build());
    }

    public SnappyCompressorOutputStream(OutputStream outputStream, long l, Parameters parameters) {
        this.os = outputStream;
        this.consumer = new ByteUtils$OutputStreamByteConsumer(outputStream);
        this.compressor = new LZ77Compressor(parameters, new SnappyCompressorOutputStream$1(this));
        this.writeUncompressedSize(l);
    }

    @Override
    public void write(int n) {
        this.oneByte[0] = (byte)(n & 0xFF);
        this.write(this.oneByte);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.compressor.compress(byArray, n, n2);
    }

    @Override
    public void close() {
        this.finish();
        this.os.close();
    }

    public void finish() {
        if (!this.finished) {
            this.compressor.finish();
            this.finished = true;
        }
    }

    private void writeUncompressedSize(long l) {
        boolean bl = false;
        do {
            int n;
            boolean bl2 = bl = l > (long)(n = (int)(l & 0x7FL));
            if (bl) {
                n |= 0x80;
            }
            this.os.write(n);
            l >>= 7;
        } while (bl);
    }

    private void writeLiteralBlock(LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock) {
        int n = lZ77Compressor$LiteralBlock.getLength();
        if (n <= 60) {
            this.writeLiteralBlockNoSizeBytes(lZ77Compressor$LiteralBlock, n);
        } else if (n <= 256) {
            this.writeLiteralBlockOneSizeByte(lZ77Compressor$LiteralBlock, n);
        } else if (n <= 65536) {
            this.writeLiteralBlockTwoSizeBytes(lZ77Compressor$LiteralBlock, n);
        } else if (n <= 0x1000000) {
            this.writeLiteralBlockThreeSizeBytes(lZ77Compressor$LiteralBlock, n);
        } else {
            this.writeLiteralBlockFourSizeBytes(lZ77Compressor$LiteralBlock, n);
        }
    }

    private void writeLiteralBlockNoSizeBytes(LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock, int n) {
        this.writeLiteralBlockWithSize(n - 1 << 2, 0, n, lZ77Compressor$LiteralBlock);
    }

    private void writeLiteralBlockOneSizeByte(LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock, int n) {
        this.writeLiteralBlockWithSize(240, 1, n, lZ77Compressor$LiteralBlock);
    }

    private void writeLiteralBlockTwoSizeBytes(LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock, int n) {
        this.writeLiteralBlockWithSize(244, 2, n, lZ77Compressor$LiteralBlock);
    }

    private void writeLiteralBlockThreeSizeBytes(LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock, int n) {
        this.writeLiteralBlockWithSize(248, 3, n, lZ77Compressor$LiteralBlock);
    }

    private void writeLiteralBlockFourSizeBytes(LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock, int n) {
        this.writeLiteralBlockWithSize(252, 4, n, lZ77Compressor$LiteralBlock);
    }

    private void writeLiteralBlockWithSize(int n, int n2, int n3, LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock) {
        this.os.write(n);
        this.writeLittleEndian(n2, n3 - 1);
        this.os.write(lZ77Compressor$LiteralBlock.getData(), lZ77Compressor$LiteralBlock.getOffset(), n3);
    }

    private void writeLittleEndian(int n, int n2) {
        ByteUtils.toLittleEndian(this.consumer, (long)n2, n);
    }

    private void writeBackReference(LZ77Compressor$BackReference lZ77Compressor$BackReference) {
        int n = lZ77Compressor$BackReference.getLength();
        int n2 = lZ77Compressor$BackReference.getOffset();
        if (n >= 4 && n <= 11 && n2 <= 1024) {
            this.writeBackReferenceWithOneOffsetByte(n, n2);
        } else if (n2 < 32768) {
            this.writeBackReferenceWithTwoOffsetBytes(n, n2);
        } else {
            this.writeBackReferenceWithFourOffsetBytes(n, n2);
        }
    }

    private void writeBackReferenceWithOneOffsetByte(int n, int n2) {
        this.os.write(1 | n - 4 << 2 | (n2 & 0x700) >> 3);
        this.os.write(n2 & 0xFF);
    }

    private void writeBackReferenceWithTwoOffsetBytes(int n, int n2) {
        this.writeBackReferenceWithLittleEndianOffset(2, 2, n, n2);
    }

    private void writeBackReferenceWithFourOffsetBytes(int n, int n2) {
        this.writeBackReferenceWithLittleEndianOffset(3, 4, n, n2);
    }

    private void writeBackReferenceWithLittleEndianOffset(int n, int n2, int n3, int n4) {
        this.os.write(n | n3 - 1 << 2);
        this.writeLittleEndian(n2, n4);
    }

    public static Parameters$Builder createParameterBuilder(int n) {
        return Parameters.builder(n).withMinBackReferenceLength(4).withMaxBackReferenceLength(64).withMaxOffset(n).withMaxLiteralLength(n);
    }

    static /* synthetic */ void access$000(SnappyCompressorOutputStream snappyCompressorOutputStream, LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock) {
        snappyCompressorOutputStream.writeLiteralBlock(lZ77Compressor$LiteralBlock);
    }

    static /* synthetic */ void access$100(SnappyCompressorOutputStream snappyCompressorOutputStream, LZ77Compressor$BackReference lZ77Compressor$BackReference) {
        snappyCompressorOutputStream.writeBackReference(lZ77Compressor$BackReference);
    }
}

