/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import java.io.InputStream;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.tukaani.xz.SingleXZInputStream;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZInputStream;

public class XZCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final InputStream in;

    public static boolean matches(byte[] byArray, int n) {
        if (n < XZ.HEADER_MAGIC.length) {
            return false;
        }
        for (int i = 0; i < XZ.HEADER_MAGIC.length; ++i) {
            if (byArray[i] == XZ.HEADER_MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    public XZCompressorInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean bl) {
        this(inputStream, bl, -1);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean bl, int n) {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = bl ? new XZInputStream((InputStream)this.countingStream, n) : new SingleXZInputStream((InputStream)this.countingStream, n);
    }

    @Override
    public int read() {
        try {
            int n = this.in.read();
            this.count(n == -1 ? -1 : 1);
            return n;
        }
        catch (org.tukaani.xz.MemoryLimitException memoryLimitException) {
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded(), memoryLimitException.getMemoryLimit(), (Exception)((Object)memoryLimitException));
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        try {
            int n3 = this.in.read(byArray, n, n2);
            this.count(n3);
            return n3;
        }
        catch (org.tukaani.xz.MemoryLimitException memoryLimitException) {
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded(), memoryLimitException.getMemoryLimit(), (Exception)((Object)memoryLimitException));
        }
    }

    @Override
    public long skip(long l) {
        try {
            return IOUtils.skip(this.in, l);
        }
        catch (org.tukaani.xz.MemoryLimitException memoryLimitException) {
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded(), memoryLimitException.getMemoryLimit(), (Exception)((Object)memoryLimitException));
        }
    }

    @Override
    public int available() {
        return this.in.available();
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }
}

