/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import java.util.HashMap;
import org.apache.commons.compress.compressors.FileNameUtil;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZUtils$CachedAvailability;

public class XZUtils {
    private static final FileNameUtil fileNameUtil;
    private static final byte[] HEADER_MAGIC;
    private static volatile XZUtils$CachedAvailability cachedXZAvailability;

    private XZUtils() {
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < HEADER_MAGIC.length) {
            return false;
        }
        for (int i = 0; i < HEADER_MAGIC.length; ++i) {
            if (byArray[i] == HEADER_MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isXZCompressionAvailable() {
        XZUtils$CachedAvailability xZUtils$CachedAvailability = cachedXZAvailability;
        if (xZUtils$CachedAvailability != XZUtils$CachedAvailability.DONT_CACHE) {
            return xZUtils$CachedAvailability == XZUtils$CachedAvailability.CACHED_AVAILABLE;
        }
        return XZUtils.internalIsXZCompressionAvailable();
    }

    private static boolean internalIsXZCompressionAvailable() {
        try {
            XZCompressorInputStream.matches(null, 0);
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public static boolean isCompressedFilename(String string) {
        return fileNameUtil.isCompressedFilename(string);
    }

    public static String getUncompressedFilename(String string) {
        return fileNameUtil.getUncompressedFilename(string);
    }

    public static String getCompressedFilename(String string) {
        return fileNameUtil.getCompressedFilename(string);
    }

    public static void setCacheXZAvailablity(boolean bl) {
        if (!bl) {
            cachedXZAvailability = XZUtils$CachedAvailability.DONT_CACHE;
        } else if (cachedXZAvailability == XZUtils$CachedAvailability.DONT_CACHE) {
            boolean bl2 = XZUtils.internalIsXZCompressionAvailable();
            cachedXZAvailability = bl2 ? XZUtils$CachedAvailability.CACHED_AVAILABLE : XZUtils$CachedAvailability.CACHED_UNAVAILABLE;
        }
    }

    static XZUtils$CachedAvailability getCachedXZAvailability() {
        return cachedXZAvailability;
    }

    static {
        HEADER_MAGIC = new byte[]{-3, 55, 122, 88, 90, 0};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(".txz", ".tar");
        hashMap.put(".xz", "");
        hashMap.put("-xz", "");
        fileNameUtil = new FileNameUtil(hashMap, ".xz");
        cachedXZAvailability = XZUtils$CachedAvailability.DONT_CACHE;
        try {
            Class.forName("org.osgi.framework.BundleEvent");
        }
        catch (Exception exception) {
            XZUtils.setCacheXZAvailablity(true);
        }
    }
}

