/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.z;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.compress.compressors.lzw.LZWInputStream;

public class ZCompressorInputStream
extends LZWInputStream {
    private static final int MAGIC_1 = 31;
    private static final int MAGIC_2 = 157;
    private static final int BLOCK_MODE_MASK = 128;
    private static final int MAX_CODE_SIZE_MASK = 31;
    private final boolean blockMode;
    private final int maxCodeSize;
    private long totalCodesRead = 0L;

    public ZCompressorInputStream(InputStream inputStream, int n) {
        super(inputStream, ByteOrder.LITTLE_ENDIAN);
        int n2 = (int)this.in.readBits(8);
        int n3 = (int)this.in.readBits(8);
        int n4 = (int)this.in.readBits(8);
        if (n2 != 31 || n3 != 157 || n4 < 0) {
            throw new IOException("Input is not in .Z format");
        }
        this.blockMode = (n4 & 0x80) != 0;
        this.maxCodeSize = n4 & 0x1F;
        if (this.blockMode) {
            this.setClearCode(9);
        }
        this.initializeTables(this.maxCodeSize, n);
        this.clearEntries();
    }

    public ZCompressorInputStream(InputStream inputStream) {
        this(inputStream, -1);
    }

    private void clearEntries() {
        this.setTableSize(256 + (this.blockMode ? 1 : 0));
    }

    @Override
    protected int readNextCode() {
        int n = super.readNextCode();
        if (n >= 0) {
            ++this.totalCodesRead;
        }
        return n;
    }

    private void reAlignReading() {
        long l = 8L - this.totalCodesRead % 8L;
        if (l == 8L) {
            l = 0L;
        }
        for (long i = 0L; i < l; ++i) {
            this.readNextCode();
        }
        this.in.clearBitCache();
    }

    @Override
    protected int addEntry(int n, byte by) {
        int n2 = 1 << this.getCodeSize();
        int n3 = this.addEntry(n, by, n2);
        if (this.getTableSize() == n2 && this.getCodeSize() < this.maxCodeSize) {
            this.reAlignReading();
            this.incrementCodeSize();
        }
        return n3;
    }

    @Override
    protected int decompressNextSymbol() {
        int n = this.readNextCode();
        if (n < 0) {
            return -1;
        }
        if (this.blockMode && n == this.getClearCode()) {
            this.clearEntries();
            this.reAlignReading();
            this.resetCodeSize();
            this.resetPreviousCode();
            return 0;
        }
        boolean bl = false;
        if (n == this.getTableSize()) {
            this.addRepeatOfPreviousCode();
            bl = true;
        } else if (n > this.getTableSize()) {
            throw new IOException(String.format("Invalid %d bit code 0x%x", this.getCodeSize(), n));
        }
        return this.expandCodeToOutputStack(n, bl);
    }

    public static boolean matches(byte[] byArray, int n) {
        return n > 3 && byArray[0] == 31 && byArray[1] == -99;
    }
}

