/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.utils.ByteUtils$ByteConsumer;
import org.apache.commons.compress.utils.ByteUtils$ByteSupplier;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static long fromLittleEndian(byte[] byArray) {
        return ByteUtils.fromLittleEndian(byArray, 0, byArray.length);
    }

    public static long fromLittleEndian(byte[] byArray, int n, int n2) {
        ByteUtils.checkReadLength(n2);
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l |= ((long)byArray[n + i] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public static long fromLittleEndian(InputStream inputStream, int n) {
        ByteUtils.checkReadLength(n);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = inputStream.read();
            if (l2 == -1L) {
                throw new IOException("premature end of data");
            }
            l |= l2 << i * 8;
        }
        return l;
    }

    public static long fromLittleEndian(ByteUtils$ByteSupplier byteUtils$ByteSupplier, int n) {
        ByteUtils.checkReadLength(n);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = byteUtils$ByteSupplier.getAsByte();
            if (l2 == -1L) {
                throw new IOException("premature end of data");
            }
            l |= l2 << i * 8;
        }
        return l;
    }

    public static long fromLittleEndian(DataInput dataInput, int n) {
        ByteUtils.checkReadLength(n);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = dataInput.readUnsignedByte();
            l |= l2 << i * 8;
        }
        return l;
    }

    public static void toLittleEndian(byte[] byArray, long l, int n, int n2) {
        long l2 = l;
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
    }

    public static void toLittleEndian(OutputStream outputStream, long l, int n) {
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            outputStream.write((int)(l2 & 0xFFL));
            l2 >>= 8;
        }
    }

    public static void toLittleEndian(ByteUtils$ByteConsumer byteUtils$ByteConsumer, long l, int n) {
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            byteUtils$ByteConsumer.accept((int)(l2 & 0xFFL));
            l2 >>= 8;
        }
    }

    public static void toLittleEndian(DataOutput dataOutput, long l, int n) {
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            dataOutput.write((int)(l2 & 0xFFL));
            l2 >>= 8;
        }
    }

    private static final void checkReadLength(int n) {
        if (n > 8) {
            throw new IllegalArgumentException("can't read more than eight bytes into a long value");
        }
    }
}

