/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.InputStream;
import java.util.zip.Checksum;

public class ChecksumCalculatingInputStream
extends InputStream {
    private final InputStream in;
    private final Checksum checksum;

    public ChecksumCalculatingInputStream(Checksum checksum, InputStream inputStream) {
        if (checksum == null) {
            throw new NullPointerException("Parameter checksum must not be null");
        }
        if (inputStream == null) {
            throw new NullPointerException("Parameter in must not be null");
        }
        this.checksum = checksum;
        this.in = inputStream;
    }

    @Override
    public int read() {
        int n = this.in.read();
        if (n >= 0) {
            this.checksum.update(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 >= 0) {
            this.checksum.update(byArray, n, n3);
        }
        return n3;
    }

    @Override
    public long skip(long l) {
        if (this.read() >= 0) {
            return 1L;
        }
        return 0L;
    }

    public long getValue() {
        return this.checksum.getValue();
    }
}

