/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class ChecksumVerifyingInputStream
extends InputStream {
    private final InputStream in;
    private long bytesRemaining;
    private final long expectedChecksum;
    private final Checksum checksum;

    public ChecksumVerifyingInputStream(Checksum checksum, InputStream inputStream, long l, long l2) {
        this.checksum = checksum;
        this.in = inputStream;
        this.expectedChecksum = l2;
        this.bytesRemaining = l;
    }

    @Override
    public int read() {
        if (this.bytesRemaining <= 0L) {
            return -1;
        }
        int n = this.in.read();
        if (n >= 0) {
            this.checksum.update(n);
            --this.bytesRemaining;
        }
        if (this.bytesRemaining == 0L && this.expectedChecksum != this.checksum.getValue()) {
            throw new IOException("Checksum verification failed");
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 >= 0) {
            this.checksum.update(byArray, n, n3);
            this.bytesRemaining -= (long)n3;
        }
        if (this.bytesRemaining <= 0L && this.expectedChecksum != this.checksum.getValue()) {
            throw new IOException("Checksum verification failed");
        }
        return n3;
    }

    @Override
    public long skip(long l) {
        if (this.read() >= 0) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public void close() {
        this.in.close();
    }
}

