/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.FilterOutputStream;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long bytesWritten = 0L;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) {
        this.out.write(n);
        this.count(1L);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.out.write(byArray, n, n2);
        this.count(n2);
    }

    protected void count(long l) {
        if (l != -1L) {
            this.bytesWritten += l;
        }
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

