/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class SeekableInMemoryByteChannel
implements SeekableByteChannel {
    private static final int NAIVE_RESIZE_LIMIT = 0x3FFFFFFF;
    private byte[] data;
    private final AtomicBoolean closed = new AtomicBoolean();
    private int position;
    private int size;

    public SeekableInMemoryByteChannel(byte[] byArray) {
        this.data = byArray;
        this.size = byArray.length;
    }

    public SeekableInMemoryByteChannel() {
        this(new byte[0]);
    }

    public SeekableInMemoryByteChannel(int n) {
        this(new byte[n]);
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long l) {
        this.ensureOpen();
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position has to be in range 0.. 2147483647");
        }
        this.position = (int)l;
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long l) {
        if ((long)this.size > l) {
            this.size = (int)l;
        }
        this.repositionIfNecessary();
        return this;
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        this.ensureOpen();
        this.repositionIfNecessary();
        int n = byteBuffer.remaining();
        int n2 = this.size - this.position;
        if (n2 <= 0) {
            return -1;
        }
        if (n > n2) {
            n = n2;
        }
        byteBuffer.put(this.data, this.position, n);
        this.position += n;
        return n;
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        this.ensureOpen();
        int n = byteBuffer.remaining();
        int n2 = this.size - this.position;
        if (n > n2) {
            int n3 = this.position + n;
            if (n3 < 0) {
                this.resize(Integer.MAX_VALUE);
                n = Integer.MAX_VALUE - this.position;
            } else {
                this.resize(n3);
            }
        }
        byteBuffer.get(this.data, this.position, n);
        this.position += n;
        if (this.size < this.position) {
            this.size = this.position;
        }
        return n;
    }

    public byte[] array() {
        return this.data;
    }

    private void resize(int n) {
        int n2 = this.data.length;
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n < 0x3FFFFFFF) {
            while (n2 < n) {
                n2 <<= 1;
            }
        } else {
            n2 = n;
        }
        this.data = Arrays.copyOf(this.data, n2);
    }

    private void ensureOpen() {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void repositionIfNecessary() {
        if (this.position > this.size) {
            this.position = this.size;
        }
    }
}

