/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.input.ReversedLinesFileReader$FilePart;

public class ReversedLinesFileReader
implements Closeable {
    private final int blockSize;
    private final Charset encoding;
    private final RandomAccessFile randomAccessFile;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private ReversedLinesFileReader$FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped = false;

    @Deprecated
    public ReversedLinesFileReader(File file) {
        this(file, 4096, Charset.defaultCharset());
    }

    public ReversedLinesFileReader(File file, Charset charset) {
        this(file, 4096, charset);
    }

    public ReversedLinesFileReader(File file, int n, Charset charset) {
        this.blockSize = n;
        this.encoding = charset;
        Charset charset2 = Charsets.toCharset(charset);
        CharsetEncoder charsetEncoder = charset2.newEncoder();
        float f2 = charsetEncoder.maxBytesPerChar();
        if (f2 == 1.0f) {
            this.byteDecrement = 1;
        } else if (charset2 == StandardCharsets.UTF_8) {
            this.byteDecrement = 1;
        } else if (charset2 == Charset.forName("Shift_JIS") || charset2 == Charset.forName("windows-31j") || charset2 == Charset.forName("x-windows-949") || charset2 == Charset.forName("gbk") || charset2 == Charset.forName("x-windows-950")) {
            this.byteDecrement = 1;
        } else if (charset2 == StandardCharsets.UTF_16BE || charset2 == StandardCharsets.UTF_16LE) {
            this.byteDecrement = 2;
        } else {
            if (charset2 == StandardCharsets.UTF_16) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + charset + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{"\r\n".getBytes(charset), "\n".getBytes(charset), "\r".getBytes(charset)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.totalByteLength = this.randomAccessFile.length();
        int n2 = (int)(this.totalByteLength % (long)n);
        if (n2 > 0) {
            this.totalBlockCount = this.totalByteLength / (long)n + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)n;
            if (this.totalByteLength > 0L) {
                n2 = n;
            }
        }
        this.currentFilePart = new ReversedLinesFileReader$FilePart(this, this.totalBlockCount, n2, null, null);
    }

    public ReversedLinesFileReader(File file, int n, String string) {
        this(file, n, Charsets.toCharset(string));
    }

    public String readLine() {
        String string = ReversedLinesFileReader$FilePart.access$100(this.currentFilePart);
        while (string == null) {
            this.currentFilePart = ReversedLinesFileReader$FilePart.access$200(this.currentFilePart);
            if (this.currentFilePart == null) break;
            string = ReversedLinesFileReader$FilePart.access$100(this.currentFilePart);
        }
        if ("".equals(string) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            string = this.readLine();
        }
        return string;
    }

    @Override
    public void close() {
        this.randomAccessFile.close();
    }

    static /* synthetic */ int access$300(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.blockSize;
    }

    static /* synthetic */ RandomAccessFile access$400(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.randomAccessFile;
    }

    static /* synthetic */ Charset access$500(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.encoding;
    }

    static /* synthetic */ int access$600(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.avoidNewlineSplitBufferSize;
    }

    static /* synthetic */ int access$700(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.byteDecrement;
    }

    static /* synthetic */ byte[][] access$800(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.newLineSequences;
    }
}

