/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.builder.ToStringStyle;

final class ToStringStyle$JsonToStringStyle
extends ToStringStyle {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_NAME_QUOTE = "\"";

    ToStringStyle$JsonToStringStyle() {
        this.setUseClassName(false);
        this.setUseIdentityHashCode(false);
        this.setContentStart("{");
        this.setContentEnd("}");
        this.setArrayStart("[");
        this.setArrayEnd("]");
        this.setFieldSeparator(",");
        this.setFieldNameValueSeparator(":");
        this.setNullText("null");
        this.setSummaryObjectStartText("\"<");
        this.setSummaryObjectEndText(">\"");
        this.setSizeStartText("\"<size=");
        this.setSizeEndText(">\"");
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, Object[] objectArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, objectArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, long[] lArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, lArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, int[] nArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, nArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, short[] sArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, sArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, byte[] byArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, byArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, char[] cArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, cArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, double[] dArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, dArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, float[] fArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, fArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, boolean[] blArray, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, blArray, bl);
    }

    @Override
    public void append(StringBuffer stringBuffer, String string, Object object, Boolean bl) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        if (!this.isFullDetail(bl)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
        super.append(stringBuffer, string, object, bl);
    }

    @Override
    protected void appendDetail(StringBuffer stringBuffer, String string, char c2) {
        this.appendValueAsString(stringBuffer, String.valueOf(c2));
    }

    @Override
    protected void appendDetail(StringBuffer stringBuffer, String string, Object object) {
        if (object == null) {
            this.appendNullText(stringBuffer, string);
            return;
        }
        if (object instanceof String || object instanceof Character) {
            this.appendValueAsString(stringBuffer, object.toString());
            return;
        }
        if (object instanceof Number || object instanceof Boolean) {
            stringBuffer.append(object);
            return;
        }
        String string2 = object.toString();
        if (this.isJsonObject(string2) || this.isJsonArray(string2)) {
            stringBuffer.append(object);
            return;
        }
        this.appendDetail(stringBuffer, string, string2);
    }

    private boolean isJsonArray(String string) {
        return string.startsWith(this.getArrayStart()) && string.startsWith(this.getArrayEnd());
    }

    private boolean isJsonObject(String string) {
        return string.startsWith(this.getContentStart()) && string.endsWith(this.getContentEnd());
    }

    private void appendValueAsString(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"').append(string).append('\"');
    }

    @Override
    protected void appendFieldStart(StringBuffer stringBuffer, String string) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
        super.appendFieldStart(stringBuffer, FIELD_NAME_QUOTE + string + FIELD_NAME_QUOTE);
    }

    private Object readResolve() {
        return ToStringStyle.JSON_STYLE;
    }
}

