/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.AbstractCircuitBreaker;
import org.apache.commons.lang3.concurrent.AbstractCircuitBreaker$State;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker$CheckIntervalData;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker$StateStrategy;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker$StateStrategyClosed;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker$StateStrategyOpen;

public class EventCountCircuitBreaker
extends AbstractCircuitBreaker<Integer> {
    private static final Map<AbstractCircuitBreaker$State, EventCountCircuitBreaker$StateStrategy> STRATEGY_MAP = EventCountCircuitBreaker.createStrategyMap();
    private final AtomicReference<EventCountCircuitBreaker$CheckIntervalData> checkIntervalData = new AtomicReference<EventCountCircuitBreaker$CheckIntervalData>(new EventCountCircuitBreaker$CheckIntervalData(0, 0L));
    private final int openingThreshold;
    private final long openingInterval;
    private final int closingThreshold;
    private final long closingInterval;

    public EventCountCircuitBreaker(int n, long l, TimeUnit timeUnit, int n2, long l2, TimeUnit timeUnit2) {
        this.openingThreshold = n;
        this.openingInterval = timeUnit.toNanos(l);
        this.closingThreshold = n2;
        this.closingInterval = timeUnit2.toNanos(l2);
    }

    public EventCountCircuitBreaker(int n, long l, TimeUnit timeUnit, int n2) {
        this(n, l, timeUnit, n2, l, timeUnit);
    }

    public EventCountCircuitBreaker(int n, long l, TimeUnit timeUnit) {
        this(n, l, timeUnit, n);
    }

    public int getOpeningThreshold() {
        return this.openingThreshold;
    }

    public long getOpeningInterval() {
        return this.openingInterval;
    }

    public int getClosingThreshold() {
        return this.closingThreshold;
    }

    public long getClosingInterval() {
        return this.closingInterval;
    }

    @Override
    public boolean checkState() {
        return this.performStateCheck(0);
    }

    @Override
    public boolean incrementAndCheckState(Integer n) {
        return this.performStateCheck(1);
    }

    public boolean incrementAndCheckState() {
        return this.incrementAndCheckState(1);
    }

    @Override
    public void open() {
        super.open();
        this.checkIntervalData.set(new EventCountCircuitBreaker$CheckIntervalData(0, this.now()));
    }

    @Override
    public void close() {
        super.close();
        this.checkIntervalData.set(new EventCountCircuitBreaker$CheckIntervalData(0, this.now()));
    }

    private boolean performStateCheck(int n) {
        long l;
        AbstractCircuitBreaker$State abstractCircuitBreaker$State;
        EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData;
        EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData2;
        do {
            l = this.now();
            abstractCircuitBreaker$State = (AbstractCircuitBreaker$State)((Object)this.state.get());
        } while (!this.updateCheckIntervalData(eventCountCircuitBreaker$CheckIntervalData2 = this.checkIntervalData.get(), eventCountCircuitBreaker$CheckIntervalData = this.nextCheckIntervalData(n, eventCountCircuitBreaker$CheckIntervalData2, abstractCircuitBreaker$State, l)));
        if (EventCountCircuitBreaker.stateStrategy(abstractCircuitBreaker$State).isStateTransition(this, eventCountCircuitBreaker$CheckIntervalData2, eventCountCircuitBreaker$CheckIntervalData)) {
            abstractCircuitBreaker$State = abstractCircuitBreaker$State.oppositeState();
            this.changeStateAndStartNewCheckInterval(abstractCircuitBreaker$State);
        }
        return !EventCountCircuitBreaker.isOpen(abstractCircuitBreaker$State);
    }

    private boolean updateCheckIntervalData(EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData, EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData2) {
        return eventCountCircuitBreaker$CheckIntervalData == eventCountCircuitBreaker$CheckIntervalData2 || this.checkIntervalData.compareAndSet(eventCountCircuitBreaker$CheckIntervalData, eventCountCircuitBreaker$CheckIntervalData2);
    }

    private void changeStateAndStartNewCheckInterval(AbstractCircuitBreaker$State abstractCircuitBreaker$State) {
        this.changeState(abstractCircuitBreaker$State);
        this.checkIntervalData.set(new EventCountCircuitBreaker$CheckIntervalData(0, this.now()));
    }

    private EventCountCircuitBreaker$CheckIntervalData nextCheckIntervalData(int n, EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData, AbstractCircuitBreaker$State abstractCircuitBreaker$State, long l) {
        EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData2 = EventCountCircuitBreaker.stateStrategy(abstractCircuitBreaker$State).isCheckIntervalFinished(this, eventCountCircuitBreaker$CheckIntervalData, l) ? new EventCountCircuitBreaker$CheckIntervalData(n, l) : eventCountCircuitBreaker$CheckIntervalData.increment(n);
        return eventCountCircuitBreaker$CheckIntervalData2;
    }

    long now() {
        return System.nanoTime();
    }

    private static EventCountCircuitBreaker$StateStrategy stateStrategy(AbstractCircuitBreaker$State abstractCircuitBreaker$State) {
        return STRATEGY_MAP.get((Object)abstractCircuitBreaker$State);
    }

    private static Map<AbstractCircuitBreaker$State, EventCountCircuitBreaker$StateStrategy> createStrategyMap() {
        EnumMap<AbstractCircuitBreaker$State, EventCountCircuitBreaker$StateStrategy> enumMap = new EnumMap<AbstractCircuitBreaker$State, EventCountCircuitBreaker$StateStrategy>(AbstractCircuitBreaker$State.class);
        enumMap.put(AbstractCircuitBreaker$State.CLOSED, new EventCountCircuitBreaker$StateStrategyClosed(null));
        enumMap.put(AbstractCircuitBreaker$State.OPEN, new EventCountCircuitBreaker$StateStrategyOpen(null));
        return enumMap;
    }
}

