/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDatePrinter;
import org.apache.commons.lang3.time.FastDatePrinter$Rule;

class FastDatePrinter$TimeZoneNameRule
implements FastDatePrinter$Rule {
    private final Locale mLocale;
    private final int mStyle;
    private final String mStandard;
    private final String mDaylight;

    FastDatePrinter$TimeZoneNameRule(TimeZone timeZone, Locale locale, int n) {
        this.mLocale = locale;
        this.mStyle = n;
        this.mStandard = FastDatePrinter.getTimeZoneDisplay(timeZone, false, n, locale);
        this.mDaylight = FastDatePrinter.getTimeZoneDisplay(timeZone, true, n, locale);
    }

    @Override
    public int estimateLength() {
        return Math.max(this.mStandard.length(), this.mDaylight.length());
    }

    @Override
    public void appendTo(Appendable appendable, Calendar calendar) {
        TimeZone timeZone = calendar.getTimeZone();
        if (calendar.get(16) != 0) {
            appendable.append(FastDatePrinter.getTimeZoneDisplay(timeZone, true, this.mStyle, this.mLocale));
        } else {
            appendable.append(FastDatePrinter.getTimeZoneDisplay(timeZone, false, this.mStyle, this.mLocale));
        }
    }
}

