/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.config;

import java.net.InetAddress;
import java.util.Collection;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;

public class RequestConfig$Builder {
    private boolean expectContinueEnabled;
    private HttpHost proxy;
    private InetAddress localAddress;
    private boolean staleConnectionCheckEnabled = false;
    private String cookieSpec;
    private boolean redirectsEnabled = true;
    private boolean relativeRedirectsAllowed = true;
    private boolean circularRedirectsAllowed;
    private int maxRedirects = 50;
    private boolean authenticationEnabled = true;
    private Collection<String> targetPreferredAuthSchemes;
    private Collection<String> proxyPreferredAuthSchemes;
    private int connectionRequestTimeout = -1;
    private int connectTimeout = -1;
    private int socketTimeout = -1;
    private boolean contentCompressionEnabled = true;

    RequestConfig$Builder() {
    }

    public RequestConfig$Builder setExpectContinueEnabled(boolean bl) {
        this.expectContinueEnabled = bl;
        return this;
    }

    public RequestConfig$Builder setProxy(HttpHost httpHost) {
        this.proxy = httpHost;
        return this;
    }

    public RequestConfig$Builder setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
        return this;
    }

    @Deprecated
    public RequestConfig$Builder setStaleConnectionCheckEnabled(boolean bl) {
        this.staleConnectionCheckEnabled = bl;
        return this;
    }

    public RequestConfig$Builder setCookieSpec(String string) {
        this.cookieSpec = string;
        return this;
    }

    public RequestConfig$Builder setRedirectsEnabled(boolean bl) {
        this.redirectsEnabled = bl;
        return this;
    }

    public RequestConfig$Builder setRelativeRedirectsAllowed(boolean bl) {
        this.relativeRedirectsAllowed = bl;
        return this;
    }

    public RequestConfig$Builder setCircularRedirectsAllowed(boolean bl) {
        this.circularRedirectsAllowed = bl;
        return this;
    }

    public RequestConfig$Builder setMaxRedirects(int n) {
        this.maxRedirects = n;
        return this;
    }

    public RequestConfig$Builder setAuthenticationEnabled(boolean bl) {
        this.authenticationEnabled = bl;
        return this;
    }

    public RequestConfig$Builder setTargetPreferredAuthSchemes(Collection<String> collection) {
        this.targetPreferredAuthSchemes = collection;
        return this;
    }

    public RequestConfig$Builder setProxyPreferredAuthSchemes(Collection<String> collection) {
        this.proxyPreferredAuthSchemes = collection;
        return this;
    }

    public RequestConfig$Builder setConnectionRequestTimeout(int n) {
        this.connectionRequestTimeout = n;
        return this;
    }

    public RequestConfig$Builder setConnectTimeout(int n) {
        this.connectTimeout = n;
        return this;
    }

    public RequestConfig$Builder setSocketTimeout(int n) {
        this.socketTimeout = n;
        return this;
    }

    @Deprecated
    public RequestConfig$Builder setDecompressionEnabled(boolean bl) {
        this.contentCompressionEnabled = bl;
        return this;
    }

    public RequestConfig$Builder setContentCompressionEnabled(boolean bl) {
        this.contentCompressionEnabled = bl;
        return this;
    }

    public RequestConfig build() {
        return new RequestConfig(this.expectContinueEnabled, this.proxy, this.localAddress, this.staleConnectionCheckEnabled, this.cookieSpec, this.redirectsEnabled, this.relativeRedirectsAllowed, this.circularRedirectsAllowed, this.maxRedirects, this.authenticationEnabled, this.targetPreferredAuthSchemes, this.proxyPreferredAuthSchemes, this.connectionRequestTimeout, this.connectTimeout, this.socketTimeout, this.contentCompressionEnabled);
    }
}

