/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.InputStream;
import org.apache.http.client.entity.InputStreamFactory;

class LazyDecompressingInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private final InputStreamFactory inputStreamFactory;
    private InputStream wrapperStream;

    public LazyDecompressingInputStream(InputStream inputStream, InputStreamFactory inputStreamFactory) {
        this.wrappedStream = inputStream;
        this.inputStreamFactory = inputStreamFactory;
    }

    private void initWrapper() {
        if (this.wrapperStream == null) {
            this.wrapperStream = this.inputStreamFactory.create(this.wrappedStream);
        }
    }

    @Override
    public int read() {
        this.initWrapper();
        return this.wrapperStream.read();
    }

    @Override
    public int read(byte[] byArray) {
        this.initWrapper();
        return this.wrapperStream.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        this.initWrapper();
        return this.wrapperStream.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) {
        this.initWrapper();
        return this.wrapperStream.skip(l);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() {
        this.initWrapper();
        return this.wrapperStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.wrapperStream != null) {
                this.wrapperStream.close();
            }
        }
        finally {
            this.wrappedStream.close();
        }
    }
}

