/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;

class NTLMEngineImpl$NTLMMessage {
    protected byte[] messageContents = null;
    protected int currentOutputPosition = 0;

    NTLMEngineImpl$NTLMMessage() {
    }

    NTLMEngineImpl$NTLMMessage(String string, int n) {
        this(Base64.decodeBase64(string.getBytes(NTLMEngineImpl.access$1700())), n);
    }

    NTLMEngineImpl$NTLMMessage(byte[] byArray, int n) {
        this.messageContents = byArray;
        if (this.messageContents.length < NTLMEngineImpl.access$1800().length) {
            throw new NTLMEngineException("NTLM message decoding error - packet too short");
        }
        for (int i = 0; i < NTLMEngineImpl.access$1800().length; ++i) {
            if (this.messageContents[i] == NTLMEngineImpl.access$1800()[i]) continue;
            throw new NTLMEngineException("NTLM message expected - instead got unrecognized bytes");
        }
        int n2 = this.readULong(NTLMEngineImpl.access$1800().length);
        if (n2 != n) {
            throw new NTLMEngineException("NTLM type " + Integer.toString(n) + " message expected - instead got type " + Integer.toString(n2));
        }
        this.currentOutputPosition = this.messageContents.length;
    }

    protected int getPreambleLength() {
        return NTLMEngineImpl.access$1800().length + 4;
    }

    protected int getMessageLength() {
        return this.currentOutputPosition;
    }

    protected byte readByte(int n) {
        if (this.messageContents.length < n + 1) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        return this.messageContents[n];
    }

    protected void readBytes(byte[] byArray, int n) {
        if (this.messageContents.length < n + byArray.length) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        System.arraycopy(this.messageContents, n, byArray, 0, byArray.length);
    }

    protected int readUShort(int n) {
        return NTLMEngineImpl.access$1900(this.messageContents, n);
    }

    protected int readULong(int n) {
        return NTLMEngineImpl.access$2000(this.messageContents, n);
    }

    protected byte[] readSecurityBuffer(int n) {
        return NTLMEngineImpl.access$2100(this.messageContents, n);
    }

    protected void prepareResponse(int n, int n2) {
        this.messageContents = new byte[n];
        this.currentOutputPosition = 0;
        this.addBytes(NTLMEngineImpl.access$1800());
        this.addULong(n2);
    }

    protected void addByte(byte by) {
        this.messageContents[this.currentOutputPosition] = by;
        ++this.currentOutputPosition;
    }

    protected void addBytes(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        byte[] byArray2 = byArray;
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            byte by;
            this.messageContents[this.currentOutputPosition] = by = byArray2[i];
            ++this.currentOutputPosition;
        }
    }

    protected void addUShort(int n) {
        this.addByte((byte)(n & 0xFF));
        this.addByte((byte)(n >> 8 & 0xFF));
    }

    protected void addULong(int n) {
        this.addByte((byte)(n & 0xFF));
        this.addByte((byte)(n >> 8 & 0xFF));
        this.addByte((byte)(n >> 16 & 0xFF));
        this.addByte((byte)(n >> 24 & 0xFF));
    }

    public String getResponse() {
        return new String(Base64.encodeBase64(this.getBytes()), Consts.ASCII);
    }

    public byte[] getBytes() {
        if (this.messageContents == null) {
            this.buildMessage();
        }
        if (this.messageContents.length > this.currentOutputPosition) {
            byte[] byArray = new byte[this.currentOutputPosition];
            System.arraycopy(this.messageContents, 0, byArray, 0, this.currentOutputPosition);
            this.messageContents = byArray;
        }
        return this.messageContents;
    }

    protected void buildMessage() {
        throw new RuntimeException("Message builder not implemented for " + this.getClass().getName());
    }
}

