/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Locale;
import java.util.Random;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.impl.auth.NTLMEngineImpl$CipherGen;
import org.apache.http.impl.auth.NTLMEngineImpl$HMACMD5;
import org.apache.http.impl.auth.NTLMEngineImpl$NTLMMessage;

class NTLMEngineImpl$Type3Message
extends NTLMEngineImpl$NTLMMessage {
    protected final byte[] type1Message;
    protected final byte[] type2Message;
    protected final int type2Flags;
    protected final byte[] domainBytes;
    protected final byte[] hostBytes;
    protected final byte[] userBytes;
    protected byte[] lmResp;
    protected byte[] ntResp;
    protected final byte[] sessionKey;
    protected final byte[] exportedSessionKey;
    protected final boolean computeMic;

    NTLMEngineImpl$Type3Message(String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2) {
        this(string, string2, string3, string4, byArray, n, string5, byArray2, null, null, null);
    }

    NTLMEngineImpl$Type3Message(Random random, long l, String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2) {
        this(random, l, string, string2, string3, string4, byArray, n, string5, byArray2, null, null, null);
    }

    NTLMEngineImpl$Type3Message(String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2, Certificate certificate, byte[] byArray3, byte[] byArray4) {
        this(NTLMEngineImpl.access$000(), System.currentTimeMillis(), string, string2, string3, string4, byArray, n, string5, byArray2, certificate, byArray3, byArray4);
    }

    NTLMEngineImpl$Type3Message(Random random, long l, String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2, Certificate certificate, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5;
        if (random == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        this.type2Flags = n;
        this.type1Message = byArray3;
        this.type2Message = byArray4;
        String string6 = NTLMEngineImpl.access$2200(string2);
        String string7 = NTLMEngineImpl.access$2300(string);
        byte[] byArray6 = byArray2;
        if (certificate != null) {
            byArray6 = this.addGssMicAvsToTargetInfo(byArray2, certificate);
            this.computeMic = true;
        } else {
            this.computeMic = false;
        }
        NTLMEngineImpl$CipherGen nTLMEngineImpl$CipherGen = new NTLMEngineImpl$CipherGen(random, l, string7, string3, string4, byArray, string5, byArray6);
        try {
            if ((n & 0x800000) != 0 && byArray2 != null && string5 != null) {
                this.ntResp = nTLMEngineImpl$CipherGen.getNTLMv2Response();
                this.lmResp = nTLMEngineImpl$CipherGen.getLMv2Response();
                byArray5 = (n & 0x80) != 0 ? nTLMEngineImpl$CipherGen.getLanManagerSessionKey() : nTLMEngineImpl$CipherGen.getNTLMv2UserSessionKey();
            } else if ((n & 0x80000) != 0) {
                this.ntResp = nTLMEngineImpl$CipherGen.getNTLM2SessionResponse();
                this.lmResp = nTLMEngineImpl$CipherGen.getLM2SessionResponse();
                byArray5 = (n & 0x80) != 0 ? nTLMEngineImpl$CipherGen.getLanManagerSessionKey() : nTLMEngineImpl$CipherGen.getNTLM2SessionResponseUserSessionKey();
            } else {
                this.ntResp = nTLMEngineImpl$CipherGen.getNTLMResponse();
                this.lmResp = nTLMEngineImpl$CipherGen.getLMResponse();
                byArray5 = (n & 0x80) != 0 ? nTLMEngineImpl$CipherGen.getLanManagerSessionKey() : nTLMEngineImpl$CipherGen.getNTLMUserSessionKey();
            }
        }
        catch (NTLMEngineException nTLMEngineException) {
            this.ntResp = new byte[0];
            this.lmResp = nTLMEngineImpl$CipherGen.getLMResponse();
            byArray5 = (n & 0x80) != 0 ? nTLMEngineImpl$CipherGen.getLanManagerSessionKey() : nTLMEngineImpl$CipherGen.getLMUserSessionKey();
        }
        if ((n & 0x10) != 0) {
            if ((n & 0x40000000) != 0) {
                this.exportedSessionKey = nTLMEngineImpl$CipherGen.getSecondaryKey();
                this.sessionKey = NTLMEngineImpl.RC4(this.exportedSessionKey, byArray5);
            } else {
                this.sessionKey = byArray5;
                this.exportedSessionKey = this.sessionKey;
            }
        } else {
            if (this.computeMic) {
                throw new NTLMEngineException("Cannot sign/seal: no exported session key");
            }
            this.sessionKey = null;
            this.exportedSessionKey = null;
        }
        Charset charset = NTLMEngineImpl.access$2500(n);
        this.hostBytes = string6 != null ? string6.getBytes(charset) : null;
        this.domainBytes = string7 != null ? string7.toUpperCase(Locale.ROOT).getBytes(charset) : null;
        this.userBytes = string3.getBytes(charset);
    }

    public byte[] getEncryptedRandomSessionKey() {
        return this.sessionKey;
    }

    public byte[] getExportedSessionKey() {
        return this.exportedSessionKey;
    }

    @Override
    protected void buildMessage() {
        int n = this.ntResp.length;
        int n2 = this.lmResp.length;
        int n3 = this.domainBytes != null ? this.domainBytes.length : 0;
        int n4 = this.hostBytes != null ? this.hostBytes.length : 0;
        int n5 = this.userBytes.length;
        int n6 = this.sessionKey != null ? this.sessionKey.length : 0;
        int n7 = 72 + (this.computeMic ? 16 : 0);
        int n8 = n7 + n2;
        int n9 = n8 + n;
        int n10 = n9 + n3;
        int n11 = n10 + n5;
        int n12 = n11 + n4;
        int n13 = n12 + n6;
        this.prepareResponse(n13, 3);
        this.addUShort(n2);
        this.addUShort(n2);
        this.addULong(n7);
        this.addUShort(n);
        this.addUShort(n);
        this.addULong(n8);
        this.addUShort(n3);
        this.addUShort(n3);
        this.addULong(n9);
        this.addUShort(n5);
        this.addUShort(n5);
        this.addULong(n10);
        this.addUShort(n4);
        this.addUShort(n4);
        this.addULong(n11);
        this.addUShort(n6);
        this.addUShort(n6);
        this.addULong(n12);
        this.addULong(this.type2Flags);
        this.addUShort(261);
        this.addULong(2600);
        this.addUShort(3840);
        int n14 = -1;
        if (this.computeMic) {
            n14 = this.currentOutputPosition;
            this.currentOutputPosition += 16;
        }
        this.addBytes(this.lmResp);
        this.addBytes(this.ntResp);
        this.addBytes(this.domainBytes);
        this.addBytes(this.userBytes);
        this.addBytes(this.hostBytes);
        if (this.sessionKey != null) {
            this.addBytes(this.sessionKey);
        }
        if (this.computeMic) {
            NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(this.exportedSessionKey);
            nTLMEngineImpl$HMACMD5.update(this.type1Message);
            nTLMEngineImpl$HMACMD5.update(this.type2Message);
            nTLMEngineImpl$HMACMD5.update(this.messageContents);
            byte[] byArray = nTLMEngineImpl$HMACMD5.getOutput();
            System.arraycopy(byArray, 0, this.messageContents, n14, byArray.length);
        }
    }

    private byte[] addGssMicAvsToTargetInfo(byte[] byArray, Certificate certificate) {
        byte[] byArray2;
        byte[] byArray3 = new byte[byArray.length + 8 + 20];
        int n = byArray.length - 4;
        System.arraycopy(byArray, 0, byArray3, 0, n);
        NTLMEngineImpl.writeUShort(byArray3, 6, n);
        NTLMEngineImpl.writeUShort(byArray3, 4, n + 2);
        NTLMEngineImpl.writeULong(byArray3, 2, n + 4);
        NTLMEngineImpl.writeUShort(byArray3, 10, n + 8);
        NTLMEngineImpl.writeUShort(byArray3, 16, n + 10);
        try {
            byte[] byArray4 = certificate.getEncoded();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray5 = messageDigest.digest(byArray4);
            byte[] byArray6 = new byte[20 + NTLMEngineImpl.access$2600().length + byArray5.length];
            NTLMEngineImpl.writeULong(byArray6, 53, 16);
            System.arraycopy(NTLMEngineImpl.access$2600(), 0, byArray6, 20, NTLMEngineImpl.access$2600().length);
            System.arraycopy(byArray5, 0, byArray6, 20 + NTLMEngineImpl.access$2600().length, byArray5.length);
            MessageDigest messageDigest2 = NTLMEngineImpl.getMD5();
            byArray2 = messageDigest2.digest(byArray6);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new NTLMEngineException(certificateEncodingException.getMessage(), certificateEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NTLMEngineException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        System.arraycopy(byArray2, 0, byArray3, n + 12, 16);
        return byArray3;
    }
}

