/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.pool.AbstractConnPool;
import org.apache.http.pool.PoolEntry;

class AbstractConnPool$2
implements Future<E> {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final AtomicReference<E> entryRef = new AtomicReference<Object>(null);
    final /* synthetic */ FutureCallback val$callback;
    final /* synthetic */ Object val$route;
    final /* synthetic */ Object val$state;
    final /* synthetic */ AbstractConnPool this$0;

    AbstractConnPool$2(AbstractConnPool abstractConnPool, FutureCallback futureCallback, Object object, Object object2) {
        this.this$0 = abstractConnPool;
        this.val$callback = futureCallback;
        this.val$route = object;
        this.val$state = object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (this.cancelled.compareAndSet(false, true)) {
            this.done.set(true);
            AbstractConnPool.access$000(this.this$0).lock();
            try {
                AbstractConnPool.access$100(this.this$0).signalAll();
            }
            finally {
                AbstractConnPool.access$000(this.this$0).unlock();
            }
            if (this.val$callback != null) {
                this.val$callback.cancelled();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public E get() {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new ExecutionException(timeoutException);
        }
    }

    @Override
    public E get(long l, TimeUnit timeUnit) {
        PoolEntry poolEntry = (PoolEntry)this.entryRef.get();
        if (poolEntry != null) {
            return poolEntry;
        }
        AbstractConnPool$2 abstractConnPool$2 = this;
        synchronized (abstractConnPool$2) {
            try {
                PoolEntry poolEntry2;
                while (true) {
                    poolEntry2 = AbstractConnPool.access$200(this.this$0, this.val$route, this.val$state, l, timeUnit, this);
                    if (AbstractConnPool.access$300(this.this$0) <= 0 || poolEntry2.getUpdated() + (long)AbstractConnPool.access$300(this.this$0) > System.currentTimeMillis() || this.this$0.validate(poolEntry2)) break;
                    poolEntry2.close();
                    this.this$0.release(poolEntry2, false);
                }
                this.entryRef.set(poolEntry2);
                this.done.set(true);
                this.this$0.onLease(poolEntry2);
                if (this.val$callback != null) {
                    this.val$callback.completed(poolEntry2);
                }
                return poolEntry2;
            }
            catch (IOException iOException) {
                this.done.set(true);
                if (this.val$callback != null) {
                    this.val$callback.failed(iOException);
                }
                throw new ExecutionException(iOException);
            }
        }
    }
}

