/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder$KeyManagerDelegate;
import org.apache.http.ssl.SSLContextBuilder$TrustManagerDelegate;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.Args;

public class SSLContextBuilder {
    static final String TLS = "TLS";
    private String protocol;
    private final Set<KeyManager> keyManagers;
    private String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String keyStoreType = KeyStore.getDefaultType();
    private final Set<TrustManager> trustManagers;
    private String trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private SecureRandom secureRandom;
    private Provider provider;

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder() {
        this.keyManagers = new LinkedHashSet<KeyManager>();
        this.trustManagers = new LinkedHashSet<TrustManager>();
    }

    @Deprecated
    public SSLContextBuilder useProtocol(String string) {
        this.protocol = string;
        return this;
    }

    public SSLContextBuilder setProtocol(String string) {
        this.protocol = string;
        return this;
    }

    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SSLContextBuilder setProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public SSLContextBuilder setProvider(String string) {
        this.provider = Security.getProvider(string);
        return this;
    }

    public SSLContextBuilder setKeyStoreType(String string) {
        this.keyStoreType = string;
        return this;
    }

    public SSLContextBuilder setKeyManagerFactoryAlgorithm(String string) {
        this.keyManagerFactoryAlgorithm = string;
        return this;
    }

    public SSLContextBuilder setTrustManagerFactoryAlgorithm(String string) {
        this.trustManagerFactoryAlgorithm = string;
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(KeyStore keyStore, TrustStrategy trustStrategy) {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustManagerFactoryAlgorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : this.trustManagerFactoryAlgorithm);
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray != null) {
            if (trustStrategy != null) {
                for (int i = 0; i < trustManagerArray.length; ++i) {
                    TrustManager trustManager = trustManagerArray[i];
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    trustManagerArray[i] = new SSLContextBuilder$TrustManagerDelegate((X509TrustManager)trustManager, trustStrategy);
                }
            }
            for (TrustManager trustManager : trustManagerArray) {
                this.trustManagers.add(trustManager);
            }
        }
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(TrustStrategy trustStrategy) {
        return this.loadTrustMaterial(null, trustStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadTrustMaterial(File file, char[] cArray, TrustStrategy trustStrategy) {
        Args.notNull(file, "Truststore file");
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            keyStore.load(fileInputStream, cArray);
        }
        finally {
            fileInputStream.close();
        }
        return this.loadTrustMaterial(keyStore, trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(File file, char[] cArray) {
        return this.loadTrustMaterial(file, cArray, null);
    }

    public SSLContextBuilder loadTrustMaterial(File file) {
        return this.loadTrustMaterial(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadTrustMaterial(URL uRL, char[] cArray, TrustStrategy trustStrategy) {
        Args.notNull(uRL, "Truststore URL");
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        InputStream inputStream = uRL.openStream();
        try {
            keyStore.load(inputStream, cArray);
        }
        finally {
            inputStream.close();
        }
        return this.loadTrustMaterial(keyStore, trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(URL uRL, char[] cArray) {
        return this.loadTrustMaterial(uRL, cArray, null);
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keyStore, char[] cArray, PrivateKeyStrategy privateKeyStrategy) {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.keyManagerFactoryAlgorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : this.keyManagerFactoryAlgorithm);
        keyManagerFactory.init(keyStore, cArray);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        if (keyManagerArray != null) {
            if (privateKeyStrategy != null) {
                for (int i = 0; i < keyManagerArray.length; ++i) {
                    KeyManager keyManager = keyManagerArray[i];
                    if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
                    keyManagerArray[i] = new SSLContextBuilder$KeyManagerDelegate((X509ExtendedKeyManager)keyManager, privateKeyStrategy);
                }
            }
            for (KeyManager keyManager : keyManagerArray) {
                this.keyManagers.add(keyManager);
            }
        }
        return this;
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keyStore, char[] cArray) {
        return this.loadKeyMaterial(keyStore, cArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadKeyMaterial(File file, char[] cArray, char[] cArray2, PrivateKeyStrategy privateKeyStrategy) {
        Args.notNull(file, "Keystore file");
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            keyStore.load(fileInputStream, cArray);
        }
        finally {
            fileInputStream.close();
        }
        return this.loadKeyMaterial(keyStore, cArray2, privateKeyStrategy);
    }

    public SSLContextBuilder loadKeyMaterial(File file, char[] cArray, char[] cArray2) {
        return this.loadKeyMaterial(file, cArray, cArray2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadKeyMaterial(URL uRL, char[] cArray, char[] cArray2, PrivateKeyStrategy privateKeyStrategy) {
        Args.notNull(uRL, "Keystore URL");
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        InputStream inputStream = uRL.openStream();
        try {
            keyStore.load(inputStream, cArray);
        }
        finally {
            inputStream.close();
        }
        return this.loadKeyMaterial(keyStore, cArray2, privateKeyStrategy);
    }

    public SSLContextBuilder loadKeyMaterial(URL uRL, char[] cArray, char[] cArray2) {
        return this.loadKeyMaterial(uRL, cArray, cArray2, null);
    }

    protected void initSSLContext(SSLContext sSLContext, Collection<KeyManager> collection, Collection<TrustManager> collection2, SecureRandom secureRandom) {
        sSLContext.init(!collection.isEmpty() ? collection.toArray(new KeyManager[collection.size()]) : null, !collection2.isEmpty() ? collection2.toArray(new TrustManager[collection2.size()]) : null, secureRandom);
    }

    public SSLContext build() {
        String string = this.protocol != null ? this.protocol : TLS;
        SSLContext sSLContext = this.provider != null ? SSLContext.getInstance(string, this.provider) : SSLContext.getInstance(string);
        this.initSSLContext(sSLContext, this.keyManagers, this.trustManagers, this.secureRandom);
        return sSLContext;
    }

    public String toString() {
        return "[provider=" + this.provider + ", protocol=" + this.protocol + ", keyStoreType=" + this.keyStoreType + ", keyManagerFactoryAlgorithm=" + this.keyManagerFactoryAlgorithm + ", keyManagers=" + this.keyManagers + ", trustManagerFactoryAlgorithm=" + this.trustManagerFactoryAlgorithm + ", trustManagers=" + this.trustManagers + ", secureRandom=" + this.secureRandom + "]";
    }
}

