/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.HashMap;
import org.json.JSONTokener;
import org.json.XML;

public class XMLTokener
extends JSONTokener {
    public static final HashMap<String, Character> entity = new HashMap(8);

    public XMLTokener(String string) {
        super(string);
    }

    public String nextCDATA() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.more()) {
            char c2 = this.next();
            stringBuilder.append(c2);
            int n = stringBuilder.length() - 3;
            if (n < 0 || stringBuilder.charAt(n) != ']' || stringBuilder.charAt(n + 1) != ']' || stringBuilder.charAt(n + 2) != '>') continue;
            stringBuilder.setLength(n);
            return stringBuilder.toString();
        }
        throw this.syntaxError("Unclosed CDATA");
    }

    public Object nextContent() {
        char c2;
        while (Character.isWhitespace(c2 = this.next())) {
        }
        if (c2 == '\u0000') {
            return null;
        }
        if (c2 == '<') {
            return XML.LT;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (c2 != '\u0000') {
            if (c2 == '<') {
                this.back();
                return stringBuilder.toString().trim();
            }
            if (c2 == '&') {
                stringBuilder.append(this.nextEntity(c2));
            } else {
                stringBuilder.append(c2);
            }
            c2 = this.next();
        }
        return stringBuilder.toString().trim();
    }

    public Object nextEntity(char c2) {
        char c3;
        StringBuilder stringBuilder = new StringBuilder();
        while (Character.isLetterOrDigit(c3 = this.next()) || c3 == '#') {
            stringBuilder.append(Character.toLowerCase(c3));
        }
        if (c3 != ';') {
            throw this.syntaxError("Missing ';' in XML entity: &" + stringBuilder);
        }
        String string = stringBuilder.toString();
        return XMLTokener.unescapeEntity(string);
    }

    static String unescapeEntity(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        if (string.charAt(0) == '#') {
            int n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
            return new String(new int[]{n}, 0, 1);
        }
        Character c2 = entity.get(string);
        if (c2 == null) {
            return '&' + string + ';';
        }
        return c2.toString();
    }

    public Object nextMeta() {
        char c2;
        while (Character.isWhitespace(c2 = this.next())) {
        }
        switch (c2) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag");
            }
            case '<': {
                return XML.LT;
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c3 = c2;
                do {
                    if ((c2 = this.next()) != '\u0000') continue;
                    throw this.syntaxError("Unterminated string");
                } while (c2 != c3);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c2 = this.next())) {
            switch (c2) {
                case '\u0000': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() {
        char c2;
        while (Character.isWhitespace(c2 = this.next())) {
        }
        switch (c2) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'");
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c3 = c2;
                StringBuilder stringBuilder = new StringBuilder();
                while (true) {
                    if ((c2 = this.next()) == '\u0000') {
                        throw this.syntaxError("Unterminated string");
                    }
                    if (c2 == c3) {
                        return stringBuilder.toString();
                    }
                    if (c2 == '&') {
                        stringBuilder.append(this.nextEntity(c2));
                        continue;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            stringBuilder.append(c2);
            c2 = this.next();
            if (Character.isWhitespace(c2)) {
                return stringBuilder.toString();
            }
            switch (c2) {
                case '\u0000': {
                    return stringBuilder.toString();
                }
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': {
                    this.back();
                    return stringBuilder.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.syntaxError("Bad character in a name");
                }
            }
        }
    }

    public void skipPast(String string) {
        char c2;
        int n;
        int n2 = 0;
        int n3 = string.length();
        char[] cArray = new char[n3];
        for (n = 0; n < n3; ++n) {
            c2 = this.next();
            if (c2 == '\u0000') {
                return;
            }
            cArray[n] = c2;
        }
        while (true) {
            int n4 = n2;
            boolean bl = true;
            for (n = 0; n < n3; ++n) {
                if (cArray[n4] != string.charAt(n)) {
                    bl = false;
                    break;
                }
                if (++n4 < n3) continue;
                n4 -= n3;
            }
            if (bl) {
                return;
            }
            c2 = this.next();
            if (c2 == '\u0000') {
                return;
            }
            cArray[n2] = c2;
            if (++n2 < n3) continue;
            n2 -= n3;
        }
    }

    static {
        entity.put("amp", XML.AMP);
        entity.put("apos", XML.APOS);
        entity.put("gt", XML.GT);
        entity.put("lt", XML.LT);
        entity.put("quot", XML.QUOT);
    }
}

