/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.controller;

import java.util.ArrayList;
import java.util.List;
import net.jankenpoi.sudokuki.model.GridChangedEvent;
import net.jankenpoi.sudokuki.model.GridModel;
import net.jankenpoi.sudokuki.view.GridView;

public class GridController {
    private GridModel model;
    List<GridView> views = new ArrayList<GridView>();
    private int lastLI = 4;
    private int lastCO = 4;

    public GridController(GridModel gridModel) {
        this.model = gridModel;
    }

    public void displayViews() {
        for (GridView gridView : this.views) {
            gridView.display();
        }
    }

    public void closeViews() {
        for (GridView gridView : this.views) {
            gridView.close();
        }
    }

    public void notifyGridChanged() {
        this.model.fireGridChanged(new GridChangedEvent(this.model, 0, 0, 0));
    }

    public void notifyGridValueChanged(int n, int n2, int n3, boolean bl) {
        this.model.setCellValue(n, n2, n3, bl);
    }

    public void notifyGridMemosChanged(int n, int n2, byte[] byArray) {
        this.model.clearCellMemos(n, n2);
        this.model.setCellMemos(n, n2, byArray);
    }

    public void addView(GridView gridView) {
        this.views.add(gridView);
        gridView.setController(this);
        gridView.gridChanged(new GridChangedEvent(this.model, 0, 0, 0));
        this.model.addGridListener(gridView);
        gridView.display();
    }

    public void notifySetAllMemosRequested() {
        this.model.setMemosForAllCells();
    }

    public void notifyClearAllMovesRequested() {
        this.model.clearAllUserMoves();
    }

    public void notifyClearAllMemosRequested() {
        this.model.clearAllUserMemos();
    }

    public void notifyEnterCustomGridMode() {
        this.model.enterCustomGridMode();
    }

    public void notifyExitCustomGridModeRequested() {
        GridModel.GridValidity gridValidity = this.model.getGridValidity();
        if (gridValidity.isGridValid()) {
            this.model.exitCustomGridMode();
        }
        this.model.fireGridChanged(new GridChangedEvent(this.model, 0, 0, 0));
    }

    public void notifyNewGridRequested() {
        if (this.model.getCustomGridMode()) {
            this.model.exitCustomGridMode();
        }
        this.model.requestNewGrid();
        this.model.fireGridChanged(new GridChangedEvent(this.model, 0, 0, 0));
    }

    public void notifyResetGridFromShorts(short[] sArray) {
        if (this.model.getCustomGridMode()) {
            this.model.exitCustomGridMode();
        }
        this.model.resetGridModelFromShorts(sArray);
        this.model.fireGridChanged(new GridChangedEvent(this.model, 0, 0, 0));
    }

    public int[] getCellInfosFromModel() {
        return this.model.asIntArray();
    }

    public void notifyGridResolutionSuccess() {
        this.notifyGridChanged();
        this.model.setGridResolved();
    }

    public void notifyGridComplete() {
        this.notifyGridChanged();
        this.model.setGridComplete();
    }

    public void notifyFocusPositionChanged(int n, int n2) {
        this.lastLI = n;
        this.lastCO = n2;
    }

    public void notifySetMemosHere() {
        this.model.setMemosForThisCell(this.lastLI, this.lastCO);
    }
}

