/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.ui.swing.DualSelectionDialog;

public class SelectMemosPanel
extends JPanel {
    private JButton btnClear;
    private JCheckBox[] ckb = new JCheckBox[9];
    private int focusedElement = 4;
    private JButton btnConfirm;
    private JPanel panelClear = new JPanel(new GridLayout());
    private JPanel panel789 = new JPanel(new GridLayout());
    private JPanel panel456 = new JPanel(new GridLayout());
    private JPanel panel123 = new JPanel(new GridLayout());
    private JPanel panelConfirm = new JPanel(new GridLayout());
    private HashSet<Byte> memos = new HashSet();
    private HashSet<Byte> previousMemos = new HashSet();
    private Font NORMAL_FONT = new Font("Serif", 0, 18);
    private InnerKeyListener innerKeyListener = new InnerKeyListener();
    private InnerFocusListener innerFocusListener = new InnerFocusListener();
    private DualSelectionDialog parent;

    public SelectMemosPanel(DualSelectionDialog dualSelectionDialog, Byte[] byteArray) {
        super(true);
        this.parent = dualSelectionDialog;
        this.initComponents(byteArray);
        dualSelectionDialog.getTabbedPane().addKeyListener(this.innerKeyListener);
        dualSelectionDialog.getTabbedPane().addFocusListener(this.innerFocusListener);
    }

    private void configureCheckBox(JCheckBox jCheckBox, String string, final int n) {
        jCheckBox.setFont(this.NORMAL_FONT);
        jCheckBox.setToolTipText(string);
        jCheckBox.setCursor(new Cursor(12));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectMemosPanel.this.buttonClicked(n);
            }
        });
        jCheckBox.addKeyListener(this.innerKeyListener);
        jCheckBox.addFocusListener(this.innerFocusListener);
    }

    private void initComponents(Byte[] byteArray) {
        Serializable serializable;
        int n;
        if (byteArray != null) {
            for (n = 0; n < byteArray.length; ++n) {
                this.memos.add(byteArray[n]);
                this.previousMemos.add(byteArray[n]);
            }
        }
        for (n = 0; n < this.ckb.length; ++n) {
            this.ckb[n] = new JCheckBox(String.valueOf(n + 1));
        }
        this.btnConfirm = new JButton();
        this.btnClear = new JButton();
        this.btnClear.setText(I18n._("Clear memos"));
        this.btnClear.setEnabled(true);
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.clearClicked();
            }

            private void clearClicked() {
                for (byte by = 1; by <= SelectMemosPanel.this.ckb.length; by = (byte)(by + 1)) {
                    SelectMemosPanel.this.memos.remove(by);
                    SelectMemosPanel.this.ckb[by - 1].setSelected(false);
                }
            }
        });
        this.btnClear.addKeyListener(this.innerKeyListener);
        this.btnClear.addFocusListener(this.innerFocusListener);
        this.configureCheckBox(this.ckb[6], "7", 6);
        this.configureCheckBox(this.ckb[7], "8", 7);
        this.configureCheckBox(this.ckb[8], "9", 8);
        this.configureCheckBox(this.ckb[3], "4", 3);
        this.configureCheckBox(this.ckb[4], "5", 4);
        this.configureCheckBox(this.ckb[5], "6", 5);
        this.configureCheckBox(this.ckb[0], "1", 0);
        this.configureCheckBox(this.ckb[1], "2", 1);
        this.configureCheckBox(this.ckb[2], "3", 2);
        this.btnConfirm.setText(I18n._("Ok"));
        this.btnConfirm.setEnabled(true);
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.confirmClicked();
            }

            private void confirmClicked() {
                SelectMemosPanel.this.parent.memosPanelConfirmed();
            }
        });
        this.btnConfirm.addKeyListener(this.innerKeyListener);
        this.btnConfirm.addFocusListener(this.innerFocusListener);
        Iterator<Byte> iterator = this.memos.iterator();
        while (iterator.hasNext()) {
            serializable = this.ckb[iterator.next().intValue() - 1];
            ((AbstractButton)serializable).setSelected(true);
        }
        serializable = new GridLayout(5, 1);
        this.setLayout((LayoutManager)((Object)serializable));
        this.add(this.panelClear);
        this.add(this.panel123);
        this.add(this.panel456);
        this.add(this.panel789);
        this.add(this.panelConfirm);
        this.panelClear.add(this.btnClear);
        this.panel789.add((Component)this.ckb[6], "Before");
        this.panel789.add((Component)this.ckb[7], "Center");
        this.panel789.add((Component)this.ckb[8], "After");
        this.panel456.add((Component)this.ckb[3], "Before");
        this.panel456.add((Component)this.ckb[4], "Center");
        this.panel456.add((Component)this.ckb[5], "After");
        this.panel123.add((Component)this.ckb[0], "Before");
        this.panel123.add((Component)this.ckb[1], "Center");
        this.panel123.add((Component)this.ckb[2], "After");
        this.panelConfirm.add(this.btnConfirm);
        this.ckb[4].requestFocusInWindow();
        this.focusedElement = 4;
    }

    private boolean isTabSelected() {
        int n = this.parent.getTabbedPane().getSelectedIndex();
        return n == 1;
    }

    private void buttonClicked(int n) {
        byte by = (byte)(n + 1);
        if (this.ckb[n].isSelected()) {
            this.memos.add(by);
        } else {
            this.memos.remove(by);
        }
    }

    public byte[] getSelectedMemos() {
        byte[] byArray = new byte[this.memos.size()];
        Iterator<Byte> iterator = this.memos.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            byArray[n] = iterator.next();
            ++n;
        }
        return byArray;
    }

    private boolean focusedOkButton() {
        return this.btnConfirm.hasFocus();
    }

    private boolean focusedClearButton() {
        return this.btnClear.hasFocus();
    }

    public boolean memosChanged() {
        return !this.previousMemos.equals(this.memos);
    }

    private class InnerFocusListener
    extends FocusAdapter {
        private InnerFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component == SelectMemosPanel.this.ckb[SelectMemosPanel.this.focusedElement]) {
                return;
            }
            for (int i = 0; i < SelectMemosPanel.this.ckb.length; ++i) {
                if (component != SelectMemosPanel.this.ckb[i]) continue;
                SelectMemosPanel.this.focusedElement = i;
                return;
            }
        }
    }

    private class InnerKeyListener
    extends KeyAdapter {
        private InnerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (SelectMemosPanel.this.isTabSelected() && this.focusedTabPane()) {
                n = keyEvent.getKeyCode();
                if (n == 72) {
                    int n2 = SelectMemosPanel.this.parent.getTabbedPane().getSelectedIndex();
                    int n3 = n2 == 0 ? 1 : 0;
                    SelectMemosPanel.this.parent.getTabbedPane().setSelectedIndex(n3);
                    SelectMemosPanel.this.parent.getTabbedPane().requestFocusInWindow();
                    return;
                }
                if (n == 76) {
                    return;
                }
            }
            if (!SelectMemosPanel.this.isTabSelected()) {
                return;
            }
            n = keyEvent.getKeyCode();
            if (n == 224 || n == 38 || n == 75) {
                if (this.focusedTabPane()) {
                    return;
                }
                if (SelectMemosPanel.this.focusedClearButton()) {
                    SelectMemosPanel.this.parent.getTabbedPane().requestFocusInWindow();
                    return;
                }
                if (SelectMemosPanel.this.focusedOkButton()) {
                    SelectMemosPanel.this.ckb[SelectMemosPanel.this.focusedElement].requestFocusInWindow();
                    return;
                }
                if (SelectMemosPanel.this.focusedElement / 3 == 0) {
                    SelectMemosPanel.this.btnClear.requestFocusInWindow();
                    return;
                }
                SelectMemosPanel.this.focusedElement = Math.max(0, SelectMemosPanel.this.focusedElement - 3);
                SelectMemosPanel.this.ckb[SelectMemosPanel.this.focusedElement].requestFocusInWindow();
            } else if (n == 225 || n == 40 || n == 74) {
                if (this.focusedTabPane()) {
                    SelectMemosPanel.this.btnClear.requestFocusInWindow();
                    return;
                }
                if (SelectMemosPanel.this.focusedOkButton()) {
                    return;
                }
                if (SelectMemosPanel.this.focusedClearButton()) {
                    SelectMemosPanel.this.focusedElement = 1;
                    SelectMemosPanel.this.ckb[SelectMemosPanel.this.focusedElement].requestFocusInWindow();
                    return;
                }
                if (SelectMemosPanel.this.focusedElement / 3 == 2) {
                    SelectMemosPanel.this.btnConfirm.requestFocusInWindow();
                    return;
                }
                SelectMemosPanel.this.focusedElement = Math.min(8, SelectMemosPanel.this.focusedElement + 3);
                SelectMemosPanel.this.ckb[SelectMemosPanel.this.focusedElement].requestFocusInWindow();
            } else if (n == 226 || n == 37 || n == 72) {
                if (SelectMemosPanel.this.focusedElement % 3 == 0 || SelectMemosPanel.this.btnConfirm.hasFocus() || SelectMemosPanel.this.btnClear.hasFocus()) {
                    return;
                }
                SelectMemosPanel.this.focusedElement = Math.max(0, SelectMemosPanel.this.focusedElement - 1);
                SelectMemosPanel.this.ckb[SelectMemosPanel.this.focusedElement].requestFocusInWindow();
            } else if (n == 227 || n == 39 || n == 76) {
                if (SelectMemosPanel.this.focusedElement % 3 == 2 || SelectMemosPanel.this.focusedOkButton() || SelectMemosPanel.this.focusedClearButton()) {
                    return;
                }
                SelectMemosPanel.this.focusedElement = Math.min(8, SelectMemosPanel.this.focusedElement + 1);
                SelectMemosPanel.this.ckb[SelectMemosPanel.this.focusedElement].requestFocusInWindow();
            } else if (n == 27) {
                SelectMemosPanel.this.parent.memosPanelEscaped();
            }
        }

        private boolean focusedTabPane() {
            return SelectMemosPanel.this.parent.getTabbedPane().hasFocus();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (!SelectMemosPanel.this.isTabSelected()) {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                if (SelectMemosPanel.this.focusedClearButton() || SelectMemosPanel.this.focusedOkButton()) {
                    return;
                }
                SelectMemosPanel.this.parent.memosPanelConfirmed();
            }
        }
    }
}

